/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.network.packet;

import java.util.function.Supplier;
import me.dantaeusb.zettergallery.ZetterGallery;
import me.dantaeusb.zettergallery.network.ServerHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CSelectOfferPacket {
    public final int offerIndex;

    public CSelectOfferPacket(int offerIndex) {
        this.offerIndex = offerIndex;
    }

    public static CSelectOfferPacket readPacketData(FriendlyByteBuf buf) {
        int offerIndex = buf.readInt();
        CSelectOfferPacket packet = new CSelectOfferPacket(offerIndex);
        return packet;
    }

    public void writePacketData(FriendlyByteBuf buf) {
        buf.writeInt(this.offerIndex);
    }

    public static void handle(CSelectOfferPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            ZetterGallery.LOG.warn("EntityPlayerMP was null when CGallerySelectOfferPacket was received");
        }
        ctx.enqueueWork(() -> ServerHandler.processGallerySelectOffer(packetIn, sendingPlayer));
    }
}

