/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.network.packet;

import java.util.Optional;
import java.util.function.Supplier;
import me.dantaeusb.zettergallery.ZetterGallery;
import me.dantaeusb.zettergallery.network.ClientHandler;
import me.dantaeusb.zettergallery.network.http.GalleryError;
import me.dantaeusb.zettergallery.network.packet.SAbstractErrorPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SAuthErrorPacket
extends SAbstractErrorPacket {
    public SAuthErrorPacket(GalleryError error) {
        super(error);
    }

    public SAuthErrorPacket(int code, String message) {
        super(code, message);
    }

    public static SAuthErrorPacket readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            int code = networkBuffer.readInt();
            String message = networkBuffer.m_130136_(Short.MAX_VALUE);
            return new SAuthErrorPacket(code, message);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ZetterGallery.LOG.warn("Exception while reading SGalleryAuthErrorPacket: " + e);
            return null;
        }
    }

    public static void handle(SAuthErrorPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ZetterGallery.LOG.warn("SGalleryAuthErrorPacket context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processPaintingMerchantAuthError(packetIn, (Level)clientWorld.get()));
    }

    public String toString() {
        return "SGalleryAuthErrorPacket[code=" + this.code + ",message=" + this.message + "]";
    }
}

