/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.network.packet;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.dantaeusb.zettergallery.ZetterGallery;
import me.dantaeusb.zettergallery.gallery.PlayerToken;
import me.dantaeusb.zettergallery.network.ClientHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SAuthenticationPlayerResponsePacket {
    public final PlayerToken.PlayerInfo playerInfo;

    public SAuthenticationPlayerResponsePacket(PlayerToken.PlayerInfo playerInfo) {
        this.playerInfo = playerInfo;
    }

    public static SAuthenticationPlayerResponsePacket readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            UUID playerUuid = networkBuffer.m_130259_();
            String playerNickname = networkBuffer.m_130136_(Short.MAX_VALUE);
            return new SAuthenticationPlayerResponsePacket(new PlayerToken.PlayerInfo(playerUuid, playerNickname));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ZetterGallery.LOG.warn("Exception while reading SGalleryAuthenticationPlayerResponsePacket: " + e);
            return null;
        }
    }

    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.m_130077_(this.playerInfo.uuid());
        networkBuffer.m_130072_(this.playerInfo.nickname(), Short.MAX_VALUE);
    }

    public static void handle(SAuthenticationPlayerResponsePacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ZetterGallery.LOG.warn("SGalleryAuthorizationResponsePacket context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processGalleryPlayerAuthorized(packetIn, (Level)clientWorld.get()));
    }

    public String toString() {
        return "SGalleryAuthenticationPlayerResponsePacket[uuid=" + this.playerInfo.uuid() + ",nickname=" + this.playerInfo.nickname() + "]";
    }
}

