/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.network.packet;

import java.util.Date;
import java.util.Optional;
import java.util.function.Supplier;
import me.dantaeusb.zettergallery.ZetterGallery;
import me.dantaeusb.zettergallery.gallery.AuthorizationCode;
import me.dantaeusb.zettergallery.network.ClientHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SAuthorizationCodeResponsePacket {
    public final AuthorizationCode authorizationCode;

    public SAuthorizationCodeResponsePacket(AuthorizationCode authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public static SAuthorizationCodeResponsePacket readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            String code = networkBuffer.m_130136_(32);
            Date issued = new Date(networkBuffer.readLong());
            Date notAfter = new Date(networkBuffer.readLong());
            AuthorizationCode crossAuthCode = new AuthorizationCode(code, issued, notAfter);
            return new SAuthorizationCodeResponsePacket(crossAuthCode);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ZetterGallery.LOG.warn("Exception while reading SGalleryAuthorizationResponsePacket: " + e);
            return null;
        }
    }

    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.m_130072_(this.authorizationCode.code, 32);
        networkBuffer.writeLong(this.authorizationCode.issuedAt.getTime());
        networkBuffer.writeLong(this.authorizationCode.notAfter.getTime());
    }

    public static void handle(SAuthorizationCodeResponsePacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ZetterGallery.LOG.warn("SGalleryAuthorizationCodeResponsePacket context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processGalleryPlayerNotAuthorized(packetIn, (Level)clientWorld.get()));
    }

    public String toString() {
        return "SGalleryAuthorizationCodeResponsePacket[code=" + this.authorizationCode.code + "]";
    }
}

