/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.network.packet;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.dantaeusb.zettergallery.ZetterGallery;
import me.dantaeusb.zettergallery.network.ClientHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SMerchantOffersPacket {
    public final UUID merchantId;
    public final int containerId;
    public final MerchantOffers offers;
    public final int villagerLevel;
    public final int villagerXp;

    public SMerchantOffersPacket(UUID merchantId, int containerId, MerchantOffers offers, int villagerLevel, int villagerXp) {
        this.merchantId = merchantId;
        this.containerId = containerId;
        this.offers = offers;
        this.villagerLevel = villagerLevel;
        this.villagerXp = villagerXp;
    }

    public static SMerchantOffersPacket readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            UUID merchantId = networkBuffer.m_130259_();
            int containerId = networkBuffer.m_130242_();
            MerchantOffers offers = MerchantOffers.m_45395_((FriendlyByteBuf)networkBuffer);
            int villagerLevel = networkBuffer.m_130242_();
            int villagerXp = networkBuffer.m_130242_();
            return new SMerchantOffersPacket(merchantId, containerId, offers, villagerLevel, villagerXp);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ZetterGallery.LOG.warn("Exception while reading SMerchantOffersPacket: " + e);
            return null;
        }
    }

    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.m_130077_(this.merchantId);
        networkBuffer.m_130130_(this.containerId);
        this.offers.m_45393_(networkBuffer);
        networkBuffer.m_130130_(this.villagerLevel);
        networkBuffer.m_130130_(this.villagerXp);
    }

    public static void handle(SMerchantOffersPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ZetterGallery.LOG.warn("SMerchantOffersPacket context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processPaintingMerchantInfo(packetIn, (Level)clientWorld.get()));
    }

    public String toString() {
        return "SMerchantOffersPacket[merchantId=" + this.merchantId + ",containerId=" + this.containerId + ",villagerLevel=" + this.villagerLevel + "]";
    }
}

