/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.network.packet;

import java.util.Optional;
import java.util.function.Supplier;
import me.dantaeusb.zettergallery.ZetterGallery;
import me.dantaeusb.zettergallery.network.ClientHandler;
import me.dantaeusb.zettergallery.trading.PaintingMerchantOffer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SOfferStatePacket {
    private final String canvasCode;
    private final PaintingMerchantOffer.State state;
    private final String message;

    public SOfferStatePacket(String canvasCode, PaintingMerchantOffer.State state, String message) {
        this.canvasCode = canvasCode;
        this.state = state;
        this.message = message;
    }

    public String getCanvasCode() {
        return this.canvasCode;
    }

    public PaintingMerchantOffer.State getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    public static SOfferStatePacket readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            String canvasCode = networkBuffer.m_130136_(Short.MAX_VALUE);
            String state = networkBuffer.m_130136_(Short.MAX_VALUE);
            String message = networkBuffer.m_130136_(Short.MAX_VALUE);
            return new SOfferStatePacket(canvasCode, PaintingMerchantOffer.State.fromValue(state), message);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ZetterGallery.LOG.warn("Exception while reading SGalleryOfferStatePacket: " + e);
            return null;
        }
    }

    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.m_130072_(this.canvasCode, Short.MAX_VALUE);
        networkBuffer.m_130072_(this.state.toValue(), Short.MAX_VALUE);
        networkBuffer.m_130072_(this.message, Short.MAX_VALUE);
    }

    public static void handle(SOfferStatePacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ZetterGallery.LOG.warn("SGalleryOfferStatePacket context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processPaintingOfferState(packetIn, (Level)clientWorld.get()));
    }

    public String toString() {
        return "SGalleryErrorPacket[message=" + this.message + "]";
    }
}

