/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.network.packet;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.Vector;
import java.util.function.Supplier;
import me.dantaeusb.zetter.core.ZetterCanvasTypes;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasDataType;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import me.dantaeusb.zettergallery.ZetterGallery;
import me.dantaeusb.zettergallery.network.ClientHandler;
import me.dantaeusb.zettergallery.network.http.dto.PaintingsResponse;
import me.dantaeusb.zettergallery.trading.PaintingMerchantPurchaseOffer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SOffersPacket {
    static final int MAX_NAME_LENGTH = 128;
    static final int MAX_AUTHOR_LENGTH = 64;
    private final PaintingsResponse.CycleInfo cycleInfo;
    private final List<PaintingMerchantPurchaseOffer> offers;

    public SOffersPacket(PaintingsResponse.CycleInfo cycleInfo, List<PaintingMerchantPurchaseOffer> offers) {
        this.cycleInfo = cycleInfo;
        this.offers = offers;
    }

    public PaintingsResponse.CycleInfo getCycleInfo() {
        return this.cycleInfo;
    }

    public List<PaintingMerchantPurchaseOffer> getOffers() {
        return this.offers;
    }

    public static SOffersPacket readPacketData(FriendlyByteBuf networkBuffer) {
        try {
            int cycleIncrementId = networkBuffer.readInt();
            Date cycleStartsAt = networkBuffer.m_130282_();
            Date cycleEndsAt = networkBuffer.m_130282_();
            String cycleSeed = networkBuffer.m_130136_(16);
            PaintingsResponse.CycleInfo cycleInfo = new PaintingsResponse.CycleInfo(cycleIncrementId, cycleSeed, cycleStartsAt, cycleEndsAt);
            int size = networkBuffer.readInt();
            Vector<PaintingMerchantPurchaseOffer> offers = new Vector<PaintingMerchantPurchaseOffer>();
            for (int i = 0; i < size; ++i) {
                UUID paintingGalleryUuid = networkBuffer.m_130259_();
                String paintingTitle = networkBuffer.m_130136_(128);
                UUID paintingAuthorUuid = networkBuffer.m_130259_();
                String paintingAuthorName = networkBuffer.m_130136_(64);
                AbstractCanvasData.Resolution resolution = AbstractCanvasData.Resolution.get((int)networkBuffer.readInt());
                int sizeH = networkBuffer.readInt();
                int sizeW = networkBuffer.readInt();
                byte[] color = networkBuffer.m_130052_();
                int price = networkBuffer.readInt();
                String feedName = networkBuffer.m_130136_(64);
                DummyCanvasData paintingData = (DummyCanvasData)((CanvasDataType)ZetterCanvasTypes.DUMMY.get()).createWrap(resolution, sizeW * resolution.getNumeric(), sizeH * resolution.getNumeric(), color);
                PaintingMerchantPurchaseOffer offer = PaintingMerchantPurchaseOffer.createOfferFromNetwork(paintingData, paintingGalleryUuid, paintingTitle, paintingAuthorUuid, paintingAuthorName, price);
                offer.setCycleInfo(cycleIncrementId, feedName);
                offers.add(offer);
            }
            return new SOffersPacket(cycleInfo, offers);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ZetterGallery.LOG.warn("Exception while reading SGallerySalesPacket: " + e);
            return null;
        }
    }

    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.writeInt(this.cycleInfo.incrementId);
        networkBuffer.m_130075_(this.cycleInfo.startsAt);
        networkBuffer.m_130075_(this.cycleInfo.endsAt);
        networkBuffer.m_130072_(this.cycleInfo.seed, 16);
        networkBuffer.writeInt(this.offers.size());
        for (PaintingMerchantPurchaseOffer merchantOffer : this.offers) {
            DummyCanvasData paintingData = merchantOffer.getDummyPaintingData();
            int resolution = paintingData.getResolution().getNumeric();
            byte[] color = new byte[paintingData.getColorDataBuffer().remaining()];
            paintingData.getColorDataBuffer().get(color);
            networkBuffer.m_130077_(merchantOffer.getPaintingUuid());
            networkBuffer.m_130072_(merchantOffer.getPaintingName(), 128);
            networkBuffer.m_130077_(merchantOffer.getAuthorUuid());
            networkBuffer.m_130072_(merchantOffer.getAuthorName(), 64);
            networkBuffer.writeInt(paintingData.getResolution().getNumeric());
            networkBuffer.writeInt(paintingData.getHeight() / resolution);
            networkBuffer.writeInt(paintingData.getWidth() / resolution);
            networkBuffer.m_130087_(color);
            networkBuffer.writeInt(merchantOffer.getPrice());
            networkBuffer.m_130072_(merchantOffer.getFeedName(), 64);
        }
    }

    public static void handle(SOffersPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        Optional clientWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(sideReceived);
        if (!clientWorld.isPresent()) {
            ZetterGallery.LOG.warn("SGalleryOffersPacket context could not provide a ClientWorld.");
            return;
        }
        ctx.enqueueWork(() -> ClientHandler.processPaintingMerchantOffers(packetIn, (Level)clientWorld.get()));
    }

    public String toString() {
        return "SGalleryOffersPacket[]";
    }
}

