/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.storage;

import java.nio.ByteBuffer;
import java.util.UUID;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasDataBuilder;
import me.dantaeusb.zetter.storage.CanvasDataType;
import me.dantaeusb.zetter.storage.PaintingData;
import me.dantaeusb.zettergallery.core.ZetterGalleryCanvasTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public class GalleryPaintingData
extends PaintingData {
    public static final String TYPE = "painting";
    public static final String CODE_PREFIX = "zettergallery_painting_";
    public static final ResourceLocation OVERLAY_KEY = new ResourceLocation("zettergallery", "gallery_painting_info");
    public static final CanvasDataBuilder<GalleryPaintingData> BUILDER = new GalleryPaintingDataBuilder();
    protected static final String NBT_TAG_GALLERY_UUID = "ZetterGalleryUuid";
    private UUID galleryPaintingUuid;

    public static String getCanvasCode(UUID canvasId) {
        return CODE_PREFIX + canvasId.toString();
    }

    public static String getDummyOfferCanvasCode(UUID galleryPaintingUuid) {
        return "zettergallery_offer_" + Long.toHexString(galleryPaintingUuid.getMostSignificantBits());
    }

    public static String getDummySaleOfferCanvasCode() {
        return "zettergallery_offer_sale";
    }

    protected GalleryPaintingData() {
    }

    public void setMetaProperties(UUID galleryPaintingUuid, UUID authorUuid, String authorName, String name) {
        this.galleryPaintingUuid = galleryPaintingUuid;
        super.setMetaProperties(authorUuid, authorName, name);
    }

    public boolean isEditable() {
        return false;
    }

    public ResourceLocation getOverlay() {
        return OVERLAY_KEY;
    }

    public CanvasDataType<GalleryPaintingData> getType() {
        return (CanvasDataType)ZetterGalleryCanvasTypes.GALLERY_PAINTING.get();
    }

    public void correctData(ServerLevel level) {
        if (this.authorUuid == null) {
            this.authorUuid = new UUID(0L, 0L);
        }
    }

    public UUID getUUID() {
        return this.galleryPaintingUuid;
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        super.m_7176_(compoundTag);
        compoundTag.m_128362_(NBT_TAG_GALLERY_UUID, this.galleryPaintingUuid);
        return compoundTag;
    }

    private static class GalleryPaintingDataBuilder
    implements CanvasDataBuilder<GalleryPaintingData> {
        private GalleryPaintingDataBuilder() {
        }

        public GalleryPaintingData createFresh(AbstractCanvasData.Resolution resolution, int width, int height) {
            GalleryPaintingData newPainting = new GalleryPaintingData();
            byte[] color = new byte[width * height * 4];
            ByteBuffer defaultColorBuffer = ByteBuffer.wrap(color);
            for (int x = 0; x < width * height; ++x) {
                defaultColorBuffer.putInt(x * 4, -2041138);
            }
            newPainting.wrapData(resolution, width, height, color);
            return newPainting;
        }

        public GalleryPaintingData createWrap(AbstractCanvasData.Resolution resolution, int width, int height, byte[] color) {
            GalleryPaintingData newPainting = new GalleryPaintingData();
            newPainting.wrapData(resolution, width, height, color);
            return newPainting;
        }

        public GalleryPaintingData load(CompoundTag compoundTag) {
            GalleryPaintingData newPainting = new GalleryPaintingData();
            newPainting.width = compoundTag.m_128451_("width");
            newPainting.height = compoundTag.m_128451_("height");
            if (compoundTag.m_128441_("resolution")) {
                int resolutionOrdinal = compoundTag.m_128451_("resolution");
                newPainting.resolution = AbstractCanvasData.Resolution.values()[resolutionOrdinal];
            } else {
                newPainting.resolution = Helper.getResolution();
            }
            newPainting.updateColorData(compoundTag.m_128463_("color"));
            if (compoundTag.m_128441_("AuthorUuid")) {
                newPainting.authorUuid = compoundTag.m_128342_("AuthorUuid");
            } else {
                newPainting.authorUuid = null;
            }
            newPainting.authorName = compoundTag.m_128461_("author_name");
            newPainting.name = compoundTag.m_128461_("title");
            newPainting.banned = compoundTag.m_128471_("Banned");
            newPainting.galleryPaintingUuid = compoundTag.m_128342_(GalleryPaintingData.NBT_TAG_GALLERY_UUID);
            return newPainting;
        }

        public GalleryPaintingData readPacketData(FriendlyByteBuf networkBuffer) {
            GalleryPaintingData newPainting = new GalleryPaintingData();
            byte resolutionOrdinal = networkBuffer.readByte();
            AbstractCanvasData.Resolution resolution = AbstractCanvasData.Resolution.values()[resolutionOrdinal];
            int width = networkBuffer.readInt();
            int height = networkBuffer.readInt();
            int colorDataSize = networkBuffer.readInt();
            ByteBuffer colorData = networkBuffer.readBytes(colorDataSize).nioBuffer();
            byte[] unwrappedColorData = new byte[width * height * 4];
            colorData.get(unwrappedColorData);
            newPainting.wrapData(resolution, width, height, unwrappedColorData);
            UUID galleryPaintingUuid = networkBuffer.m_130259_();
            UUID authorUuid = networkBuffer.m_130259_();
            String authorName = networkBuffer.m_130136_(64);
            String title = networkBuffer.m_130136_(32);
            newPainting.setMetaProperties(galleryPaintingUuid, authorUuid, authorName, title);
            return newPainting;
        }

        public void writePacketData(GalleryPaintingData canvasData, FriendlyByteBuf networkBuffer) {
            networkBuffer.writeByte(canvasData.resolution.ordinal());
            networkBuffer.writeInt(canvasData.width);
            networkBuffer.writeInt(canvasData.height);
            networkBuffer.writeInt(canvasData.getColorDataBuffer().remaining());
            networkBuffer.writeBytes(canvasData.getColorDataBuffer());
            networkBuffer.m_130077_(canvasData.galleryPaintingUuid);
            networkBuffer.m_130077_(canvasData.authorUuid);
            networkBuffer.m_130072_(canvasData.authorName, 64);
            networkBuffer.m_130072_(canvasData.name, 32);
        }
    }
}

