/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.trading;

import java.util.UUID;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import me.dantaeusb.zettergallery.network.http.GalleryError;
import net.minecraft.world.item.ItemStack;

public interface PaintingMerchantOffer {
    public String getRealCanvasCode();

    public String getDummyCanvasCode();

    public String getPaintingName();

    public DummyCanvasData getDummyPaintingData();

    public int getPrice();

    public UUID getAuthorUuid();

    public String getAuthorName();

    public boolean isLoading();

    public boolean isReady();

    public boolean isError();

    public ItemStack getOfferResult();

    public void unfulfilled();

    public void ready();

    public void markError(GalleryError var1);

    public String getErrorMessage();

    public static enum State {
        WAITING("waiting"),
        UNFULFILLED("unfulfilled"),
        READY("ready"),
        ERROR("error");

        private final String value;

        private State(String value) {
            this.value = value;
        }

        public static State fromValue(String value) {
            if (value != null) {
                for (State state : State.values()) {
                    if (!state.value.equals(value)) continue;
                    return state;
                }
            }
            throw new IllegalArgumentException(value + " is not an offer state");
        }

        public String toValue() {
            return this.value;
        }
    }
}

