/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zettergallery.trading;

import java.util.UUID;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterCanvasTypes;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasDataType;
import me.dantaeusb.zetter.storage.DummyCanvasData;
import me.dantaeusb.zetter.storage.PaintingData;
import me.dantaeusb.zettergallery.network.http.GalleryError;
import me.dantaeusb.zettergallery.storage.GalleryPaintingData;
import me.dantaeusb.zettergallery.trading.PaintingMerchantAbstractOffer;
import me.dantaeusb.zettergallery.trading.PaintingMerchantOffer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PaintingMerchantSaleOffer
extends PaintingMerchantAbstractOffer {
    public static final Component ANOTHER_PLAYERS_PAINTING_ERROR = Component.m_237115_((String)"container.zettergallery.merchant.another_players_painting");
    public static final Component NOT_ORIGINAL_PAINTING_ERROR = Component.m_237115_((String)"container.zettergallery.merchant.not_original_painting");
    private final String realCanvasCode;
    private final int generation;
    private DummyCanvasData paintingDummyData;
    private String paintingName;
    private UUID paintingAuthorUuid;
    private String paintingAuthorName;

    private PaintingMerchantSaleOffer(String canvasCode, DummyCanvasData paintingData, String paintingTitle, UUID paintingAuthorUuid, String paintingAuthorName, int generation, int price) {
        super(price, PaintingMerchantOffer.State.WAITING);
        this.realCanvasCode = canvasCode;
        this.paintingDummyData = paintingData;
        this.paintingName = paintingTitle;
        this.paintingAuthorUuid = paintingAuthorUuid;
        this.paintingAuthorName = paintingAuthorName;
        this.generation = generation;
    }

    private PaintingMerchantSaleOffer(String canvasCode, UUID paintingAuthorUuid, String paintingAuthorName, int generation, int price) {
        super(price, PaintingMerchantOffer.State.WAITING);
        this.realCanvasCode = canvasCode;
        this.paintingAuthorUuid = paintingAuthorUuid;
        this.paintingAuthorName = paintingAuthorName;
        this.generation = generation;
    }

    public static PaintingMerchantSaleOffer createOfferFromPlayersPainting(String canvasCode, PaintingData paintingData, int generation, int price) {
        DummyCanvasData paintingWrap = (DummyCanvasData)((CanvasDataType)ZetterCanvasTypes.DUMMY.get()).createWrap(paintingData.getResolution(), paintingData.getWidth(), paintingData.getHeight(), paintingData.getColorData());
        return new PaintingMerchantSaleOffer(canvasCode, paintingWrap, paintingData.getPaintingName(), paintingData.getAuthorUuid(), paintingData.getAuthorName(), generation, price);
    }

    public static PaintingMerchantSaleOffer createOfferWithoutPlayersPainting(String canvasCode, Player player, int generation, int price) {
        return new PaintingMerchantSaleOffer(canvasCode, player.m_20148_(), player.m_7755_().getString(), generation, price);
    }

    public void register(Level level) {
        Helper.getLevelCanvasTracker((Level)level).registerCanvasData(this.getDummyCanvasCode(), (AbstractCanvasData)this.getDummyPaintingData());
    }

    public static void unregister(Level level) {
        Helper.getLevelCanvasTracker((Level)level).unregisterCanvasData(PaintingMerchantSaleOffer.getStaticCanvasCode());
    }

    public boolean validate(Merchant merchant) {
        if (!merchant.m_7962_().m_20148_().equals(this.paintingAuthorUuid)) {
            this.markError(new GalleryError(1005, ANOTHER_PLAYERS_PAINTING_ERROR.getString()));
            return false;
        }
        return true;
    }

    public void updatePaintingData(String paintingName, DummyCanvasData paintingData, UUID paintingAuthorUuid, String paintingAuthorName) {
        this.paintingName = paintingName;
        this.paintingDummyData = paintingData;
        this.paintingAuthorUuid = paintingAuthorUuid;
        this.paintingAuthorName = paintingAuthorName;
        this.state = PaintingMerchantOffer.State.UNFULFILLED;
    }

    @Override
    public String getRealCanvasCode() {
        return this.realCanvasCode;
    }

    @Override
    public String getDummyCanvasCode() {
        return PaintingMerchantSaleOffer.getStaticCanvasCode();
    }

    public static String getStaticCanvasCode() {
        return GalleryPaintingData.getDummySaleOfferCanvasCode();
    }

    @Override
    public DummyCanvasData getDummyPaintingData() {
        if (this.isLoading() || this.paintingDummyData == null) {
            throw new IllegalStateException("Sale offer is still loading");
        }
        return this.paintingDummyData;
    }

    @Override
    public String getPaintingName() {
        if (this.isLoading() || this.paintingName == null) {
            throw new IllegalStateException("Sale offer is still loading");
        }
        return this.paintingName;
    }

    @Override
    public UUID getAuthorUuid() {
        return this.paintingAuthorUuid;
    }

    @Override
    public String getAuthorName() {
        return this.paintingAuthorName;
    }

    @Override
    public boolean isLoading() {
        return this.paintingDummyData == null;
    }

    @Override
    public ItemStack getOfferResult() {
        if (this.isReady()) {
            return new ItemStack((ItemLike)Items.f_42616_, this.price);
        }
        return ItemStack.f_41583_;
    }
}

