/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.syp.entity;

import com.lupicus.syp.advancements.ModTriggers;
import com.lupicus.syp.config.MyConfig;
import com.lupicus.syp.entity.IDying;
import com.lupicus.syp.item.ModItems;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class DyingEntity
extends TamableAnimal
implements IDying {
    protected long woundedTime;
    protected int woundedTicks;
    protected UUID killerUUID;
    protected UUID scoreUUID;

    protected DyingEntity(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("WoundedTime")) {
            this.woundedTime = compound.m_128454_("WoundedTime");
            this.woundedTicks = this.f_19797_;
            this.woundedTicks = compound.m_128441_("WoundedTicks") ? (this.woundedTicks -= compound.m_128451_("WoundedTicks")) : (this.woundedTicks -= (int)(this.m_9236_().m_46467_() - this.woundedTime));
            if (compound.m_128403_("sypKiller")) {
                this.killerUUID = compound.m_128342_("sypKiller");
            }
            if (compound.m_128403_("sypScore")) {
                this.scoreUUID = compound.m_128342_("sypScore");
            }
            this.f_19804_.m_135381_(f_19806_, (Object)Pose.DYING);
            this.m_21153_(0.0f);
            this.f_20919_ = 20;
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.isDying()) {
            compound.m_128356_("WoundedTime", this.woundedTime);
            compound.m_128405_("WoundedTicks", this.f_19797_ - this.woundedTicks);
            if (this.killerUUID != null) {
                compound.m_128362_("sypKiller", this.killerUUID);
            }
            if (this.scoreUUID != null) {
                compound.m_128362_("sypScore", this.scoreUUID);
            }
        }
    }

    public void m_6667_(DamageSource cause) {
        if (!this.m_21824_()) {
            super.m_6667_(cause);
            return;
        }
        if (!this.isDying()) {
            LivingEntity le;
            LivingEntity player = this.m_269323_();
            if (player instanceof ServerPlayer && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_)) {
                ResourceLocation res = EntityType.m_20613_((EntityType)this.m_6095_());
                String type = res.m_135827_().equals("minecraft") ? res.m_135815_() : "generic";
                MutableComponent msg = Component.m_237115_((String)("syp.pet_dying." + type));
                if (this.m_8077_()) {
                    msg.m_7220_((Component)Component.m_237113_((String)" ")).m_7220_(this.m_7770_());
                }
                if (MyConfig.showLoc) {
                    msg.m_7220_((Component)Component.m_237113_((String)(" " + this.formatLoc(this.m_20182_()))));
                }
                player.m_213846_((Component)msg);
            }
            this.f_19804_.m_135381_(f_19806_, (Object)Pose.DYING);
            this.woundedTime = this.m_9236_().m_46467_();
            this.woundedTicks = this.f_19797_;
            Entity entity = cause.m_7639_();
            if (entity instanceof ServerPlayer) {
                this.killerUUID = entity.m_20148_();
            }
            if ((le = this.m_21232_()) instanceof ServerPlayer) {
                this.scoreUUID = le.m_20148_();
            }
            this.m_146922_(this.f_20883_);
            this.f_20885_ = this.f_20883_;
            this.m_146926_(0.0f);
        }
    }

    protected void m_6153_() {
        if (!this.m_21824_()) {
            super.m_6153_();
            return;
        }
        if (this.f_20919_ < 20) {
            ++this.f_20919_;
            if (this.f_20919_ == 10) {
                this.m_20090_();
            }
        } else if (!this.m_9236_().m_5776_()) {
            int time;
            int n = time = MyConfig.useWorldTicks ? (int)(this.m_9236_().m_46467_() - this.woundedTime) : this.f_19797_ - this.woundedTicks;
            if (time < MyConfig.deathTimer) {
                return;
            }
            if (MyConfig.autoHeal) {
                this.cureEntity(ModItems.GOLDEN_PET_BANDAGE);
            } else {
                this.killEntity();
            }
        }
    }

    void killEntity() {
        Player aPlayer;
        if (this.scoreUUID != null) {
            this.f_20888_ = this.m_9236_().m_46003_(this.scoreUUID);
        }
        DamageSource ds = this.m_269291_().m_269264_();
        if (this.killerUUID != null && (aPlayer = this.m_9236_().m_46003_(this.killerUUID)) != null) {
            ds = this.m_269291_().m_269075_(aPlayer);
        }
        super.m_6667_(ds);
        this.f_20919_ = 19;
        super.m_6153_();
    }

    public void m_7822_(byte id) {
        if (id == 101) {
            this.cureEntity(null);
        } else {
            super.m_7822_(id);
        }
    }

    @Override
    public boolean isDying() {
        return this.f_19804_.m_135370_(f_19806_) == Pose.DYING && this.m_21824_() && !this.m_213877_();
    }

    @Override
    public InteractionResult dyingInteract(Player player, InteractionHand hand) {
        if (!this.isDying()) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item == ModItems.PET_BANDAGE || item == ModItems.GOLDEN_PET_BANDAGE) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (player instanceof ServerPlayer) {
                ModTriggers.SAVE_PET.trigger((ServerPlayer)player, (Animal)this);
                this.cureEntity(item);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (item == Items.f_42675_) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (player instanceof ServerPlayer) {
                this.killerUUID = player.m_20148_();
                this.killEntity();
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return InteractionResult.PASS;
    }

    void cureEntity(Item item) {
        Level level = this.m_9236_();
        if (level.f_46443_) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        } else {
            level.m_7605_((Entity)this, (byte)101);
        }
        this.m_20256_(Vec3.f_82478_);
        this.f_19804_.m_135381_(f_19806_, (Object)Pose.STANDING);
        this.killerUUID = null;
        this.scoreUUID = null;
        this.m_21153_(1.0f);
        this.f_20919_ = 0;
        if (!level.f_46443_ && this.m_5830_()) {
            this.m_6034_(Math.floor(this.m_20185_()) + 0.5, this.m_20186_(), Math.floor(this.m_20189_()) + 0.5);
            if (this.m_5830_()) {
                this.m_21153_(3.0f);
            }
        } else {
            this.m_20090_();
        }
        if (item == ModItems.GOLDEN_PET_BANDAGE) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, MyConfig.healTime, 1));
        }
    }

    protected AABB m_142242_() {
        return this.f_20919_ >= 10 ? this.dyingBoundingBox() : super.m_142242_();
    }

    private AABB dyingBoundingBox() {
        double ang = (double)this.m_146908_() * (Math.PI / 180);
        EntityDimensions size = this.m_6972_(Pose.STANDING);
        double width = (double)size.f_20377_ / 2.0;
        double length = (double)size.f_20378_ / 2.0;
        double lcos = length * Math.cos(ang);
        double lsin = length * Math.sin(ang);
        double x0 = this.m_20185_();
        double x1 = x0 + lcos;
        double y0 = this.m_20186_();
        double z0 = this.m_20189_();
        double z1 = z0 + lsin;
        double hw = (width + length) / 2.0;
        double xmin = x1 - hw;
        double xmax = x1 + hw;
        if (x0 < xmin) {
            xmin = x0;
        } else if (x0 > xmax) {
            xmax = x0;
        }
        double zmin = z1 - hw;
        double zmax = z1 + hw;
        if (z0 < zmin) {
            zmin = z0;
        } else if (z0 > zmax) {
            zmax = z0;
        }
        return new AABB(xmin, y0, zmin, xmax, y0 + width, zmax);
    }
}

