/*
 * Decompiled with CFR 0.152.
 */
package com.cak.trading_floor.foundation.ponder_scenes;

import com.cak.trading_floor.content.trading_depot.CommonTradingDepotBlockEntity;
import com.cak.trading_floor.registry.TFParticleEmitters;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;

public class TradingDepotScenes {
    public static void trading(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("trading_depot_trading", "Trading with trading depots");
        scene.configureBasePlate(0, 0, 3);
        scene.showBasePlate();
        scene.idle(10);
        scene.world().showSection(util.select().position(1, 1, 1), Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(80).placeNearTarget().pointAt(new Vec3(1.5, 1.5, 1.5)).text("To use a trading depot, attach it to a villager workstation");
        scene.addKeyframe();
        scene.idle(80);
        scene.world().showSection(util.select().position(1, 1, 2), Direction.DOWN);
        scene.idle(40);
        scene.overlay().showOutline(PonderPalette.GREEN, (Object)"Depot Highlight", util.select().position(1, 1, 1), 30);
        scene.idle(1);
        scene.overlay().showOutline(PonderPalette.WHITE, (Object)"Workstation Highlight", util.select().position(1, 1, 2), 28);
        scene.addKeyframe();
        scene.idle(80);
        scene.world().modifyBlockEntity(new BlockPos(1, 1, 1), CommonTradingDepotBlockEntity.class, be -> {
            TransportedItemStack tis = new TransportedItemStack(Items.f_42484_.m_7968_().m_255036_(32));
            tis.insertedFrom = Direction.SOUTH;
            be.getCommonTradingDepotBehaviour().getIncoming().add(tis);
        });
        scene.idle(20);
        ElementLink villager = scene.world().createEntity(level -> {
            Villager newEntity = new Villager(EntityType.f_20492_, level);
            newEntity.m_6034_(2.5, 1.0, 2.5);
            newEntity.m_5616_(90.0f);
            newEntity.m_5618_(90.0f);
            newEntity.m_146867_();
            newEntity.m_8119_();
            newEntity.m_34375_(newEntity.m_7141_().m_35565_(VillagerProfession.f_35592_));
            return newEntity;
        });
        scene.idle(40);
        scene.overlay().showText(80).placeNearTarget().pointAt(new Vec3(1.5, 1.5, 1.5)).text("When a villager next works at their workstation they will trade with the attached depot");
        scene.addKeyframe();
        scene.idle(40);
        scene.world().modifyEntity(villager, entity -> {
            Villager villagerEntity = (Villager)entity;
            villagerEntity.m_146926_(10.0f);
        });
        scene.idle(1);
        scene.world().modifyEntity(villager, entity -> {
            Villager villagerEntity = (Villager)entity;
            villagerEntity.m_146926_(20.0f);
        });
        scene.idle(20);
        scene.addInstruction(activeScene -> TFParticleEmitters.TRADE_COMPLETED.emitWithConsumer((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((PonderLevel)activeScene.getWorld()).m_7106_(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), new Vec3(1.5, 1.9, 1.5), 4));
        scene.world().modifyBlockEntity(new BlockPos(1, 1, 1), CommonTradingDepotBlockEntity.class, be -> {
            be.getCommonTradingDepotBehaviour().setOfferStack(ItemStack.f_41583_);
            be.getCommonTradingDepotBehaviour().getResults().add(Items.f_42616_.m_7968_());
        });
        scene.markAsFinished();
    }

    public static void trading_double(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("trading_depot_double_trading", "Trading with multiple trading depots");
        scene.configureBasePlate(0, 0, 6);
        scene.showBasePlate();
        scene.idle(20);
        scene.world().showSection(util.select().fromTo(6, 0, 0, 6, 2, 5), Direction.WEST);
        scene.idle(20);
        scene.world().showSection(util.select().layer(1).substract(util.select().fromTo(6, 0, 0, 6, 2, 5)).substract(util.select().position(0, 1, 3)), Direction.DOWN);
        scene.idle(20);
        scene.world().showSection(util.select().layer(2).substract(util.select().fromTo(6, 0, 0, 6, 2, 5)).substract(util.select().position(2, 2, 2)).substract(util.select().position(1, 2, 3)), Direction.DOWN);
        scene.world().showSection(util.select().position(0, 1, 3).add(util.select().position(1, 2, 3)), Direction.DOWN);
        scene.addKeyframe();
        scene.idle(20);
        scene.overlay().showText(80).placeNearTarget().pointAt(new Vec3(3.5, 2.5, 3.5)).text("To complete trades with multiple inputs, 2 depots can be used together");
        scene.idle(90);
        scene.overlay().showText(80).placeNearTarget().pointAt(new Vec3(3.5, 2.5, 2.5)).text("While not required, you should set the filter on the first input to avoid other trades");
        scene.idle(90);
        scene.world().createItemOnBelt(new BlockPos(3, 2, 0), Direction.NORTH, Items.f_42616_.m_7968_());
        scene.world().createItemOnBelt(new BlockPos(0, 1, 3), Direction.WEST, Items.f_41832_.m_7968_().m_255036_(10));
        scene.idle(60);
        ElementLink villager = scene.world().createEntity(level -> {
            Villager newEntity = new Villager(EntityType.f_20492_, level);
            newEntity.m_6034_(4.5, 2.0, 4.5);
            newEntity.m_5616_(135.0f);
            newEntity.m_5618_(135.0f);
            newEntity.m_146867_();
            newEntity.m_8119_();
            newEntity.m_34375_(newEntity.m_7141_().m_35565_(VillagerProfession.f_35592_));
            return newEntity;
        });
        scene.addKeyframe();
        scene.idle(20);
        scene.overlay().showText(80).placeNearTarget().pointAt(new Vec3(3.5, 2.5, 2.5)).text("Note that trading depots will only share contents if they have matching filters, or the other is empty");
        scene.idle(90);
        scene.world().modifyEntity(villager, entity -> {
            Villager villagerEntity = (Villager)entity;
            villagerEntity.m_146926_(10.0f);
        });
        scene.idle(1);
        scene.world().modifyEntity(villager, entity -> {
            Villager villagerEntity = (Villager)entity;
            villagerEntity.m_146926_(20.0f);
        });
        scene.addKeyframe();
        scene.idle(20);
        scene.addInstruction(activeScene -> TFParticleEmitters.TRADE_COMPLETED.emitWithConsumer((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((PonderLevel)activeScene.getWorld()).m_7106_(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), new Vec3(3.5, 2.9, 2.5), 4));
        scene.world().modifyBlockEntity(new BlockPos(3, 2, 2), CommonTradingDepotBlockEntity.class, tradingDepotBlockEntity -> tradingDepotBlockEntity.getCommonTradingDepotBehaviour().setOfferStack(ItemStack.f_41583_));
        scene.world().modifyBlockEntity(new BlockPos(2, 2, 3), CommonTradingDepotBlockEntity.class, tradingDepotBlockEntity -> tradingDepotBlockEntity.getCommonTradingDepotBehaviour().setOfferStack(ItemStack.f_41583_));
        scene.world().modifyBlockEntity(new BlockPos(3, 2, 2), CommonTradingDepotBlockEntity.class, tradingDepotBlockEntity -> tradingDepotBlockEntity.getCommonTradingDepotBehaviour().getResults().add(Items.f_42484_.m_7968_().m_255036_(10)));
        scene.idle(20);
        scene.overlay().showText(80).placeNearTarget().pointAt(new Vec3(3.5, 2.5, 2.5)).text("The output then goes to whichever depot has the first item of the trade");
        scene.idle(90);
        scene.world().showSection(util.select().position(2, 2, 2), Direction.DOWN);
        scene.idle(20);
        scene.world().modifyBlockEntity(new BlockPos(3, 2, 2), CommonTradingDepotBlockEntity.class, tradingDepotBlockEntity -> tradingDepotBlockEntity.getCommonTradingDepotBehaviour().getResults().clear());
        scene.world().createItemOnBelt(new BlockPos(2, 1, 2), Direction.EAST, Items.f_42484_.m_7968_().m_255036_(10));
        scene.idle(20);
        scene.markAsFinished();
    }
}

