/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.commands;

import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.gui.utils.Colors;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;

public class WaystoneArgument
implements ArgumentType<String> {
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> Register = DeferredRegister.create((ResourceKey)Registries.f_256982_, (String)"signpost");
    private static final Pattern nonLiteralPattern;

    public static void register(IEventBus bus) {
        Register.register(bus);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readString();
        if (WaystoneLibrary.hasInstance() && WaystoneLibrary.getInstance().getAllWaystoneNames(false).map(n -> n.contains(name)).orElse(true).booleanValue()) {
            return name;
        }
        throw new SimpleCommandExceptionType((Message)Component.m_237110_((String)"signpost.waystone_not_found", (Object[])new Object[]{Colors.wrap(name, Colors.highlight)})).create();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (!WaystoneLibrary.hasInstance()) {
            return SharedSuggestionProvider.m_82970_(new HashSet(), (SuggestionsBuilder)builder);
        }
        CompletableFuture<Suggestions> ret = new CompletableFuture<Suggestions>();
        WaystoneLibrary.getInstance().requestAllWaystoneNames(names -> SharedSuggestionProvider.m_82970_((Iterable)names.values().stream().map(s -> nonLiteralPattern.matcher((CharSequence)s).find() ? "\"" + s + "\"" : s).collect(Collectors.toSet()), (SuggestionsBuilder)builder).thenAccept(ret::complete), Optional.empty(), Signpost.getServerType().isClient);
        return ret;
    }

    static {
        Register.register("waystone", () -> (Info)ArgumentTypeInfos.registerByClass(WaystoneArgument.class, (ArgumentTypeInfo)new Info()));
        nonLiteralPattern = Pattern.compile("[^a-z0-9]", 2);
    }

    private static class Info
    implements ArgumentTypeInfo<WaystoneArgument, Template> {
        private Info() {
        }

        public void serializeToNetwork(Template arg, FriendlyByteBuf buffer) {
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            return new Template();
        }

        public void serializeToJson(Template arg, JsonObject buffer) {
        }

        public Template unpack(WaystoneArgument argument) {
            return new Template();
        }

        public final class Template
        implements ArgumentTypeInfo.Template<WaystoneArgument> {
            public WaystoneArgument instantiate(CommandBuildContext context) {
                return new WaystoneArgument();
            }

            public ArgumentTypeInfo<WaystoneArgument, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

