/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.events.WaystoneRenamedEvent;
import gollorum.signpost.events.WaystoneUpdatedEvent;
import gollorum.signpost.minecraft.gui.utils.ExtendedScreen;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.utils.TextureSize;
import gollorum.signpost.minecraft.gui.widgets.ImageInputBox;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.LockIconButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class WaystoneGui
extends ExtendedScreen {
    private final WorldLocation location;
    private final Optional<WaystoneData> oldData;
    private ImageInputBox inputBox;
    private Optional<Set<String>> allWaystoneNames = Optional.empty();
    private static final TextureResource texture = TextureResource.waystoneNameField;
    private static final int inputBoxScale = 3;
    private static final int inputBoxYOffset = -46;
    private static final int buttonsYOffset = 46;
    private static final TextureSize buttonsSize = new TextureSize(98, 20);
    private LockIconButton lockButton;
    private Button doneButton;
    private final Consumer<WaystoneUpdatedEvent> waystoneUpdateListener = event -> this.allWaystoneNames.ifPresent(names -> {
        switch (event.getType()) {
            case Added: {
                names.add(event.name);
                break;
            }
            case Removed: {
                names.remove(event.name);
                break;
            }
            case Renamed: {
                names.remove(((WaystoneRenamedEvent)event).oldName);
                names.add(event.name);
            }
        }
    });

    public WaystoneGui(WorldLocation location, Optional<WaystoneData> oldData) {
        super((Component)Component.m_237113_((String)"Waystone"));
        this.location = location;
        this.oldData = oldData;
    }

    public static void display(WorldLocation location, Optional<WaystoneData> oldData) {
        Minecraft.m_91087_().m_91152_((Screen)new WaystoneGui(location, oldData));
    }

    private int getCenterX() {
        return this.f_96543_ / 2;
    }

    private int getCenterY() {
        return this.f_96544_ / 2;
    }

    protected void m_7856_() {
        super.m_7856_();
        WaystoneLibrary.getInstance().requestAllWaystoneNames(names -> {
            this.allWaystoneNames = Optional.of(new HashSet(names.values()));
        }, Optional.empty(), true);
        WaystoneLibrary.getInstance().updateEventDispatcher.addListener(this.waystoneUpdateListener);
        Point point = new Point(this.getCenterX(), this.getCenterY() + -46);
        int n = (WaystoneGui.texture.size.width - 6) * 3;
        Objects.requireNonNull(this.f_96547_);
        this.inputBox = new ImageInputBox(this.f_96547_, new Rect(point, new TextureSize(n, 9), Rect.XAlignment.Center, Rect.YAlignment.Bottom), new Rect(Point.zero, WaystoneGui.texture.size.scale(3.0f), Rect.XAlignment.Center, Rect.YAlignment.Center), Rect.XAlignment.Center, Rect.YAlignment.Center, texture, true, 0.0);
        this.lockButton = new LockIconButton(this.inputBox.m_252754_() + this.inputBox.width() + 10, this.inputBox.m_252907_() + this.inputBox.m_93694_() / 2 - 10, b -> this.lockButton.m_94309_(!this.lockButton.m_94302_()));
        this.m_142416_((GuiEventListener)this.lockButton);
        this.oldData.ifPresent(data -> {
            this.inputBox.m_94144_(data.name);
            this.lockButton.m_94309_(data.isLocked);
        });
        this.doneButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> this.done()).m_252987_(this.getCenterX() - WaystoneGui.buttonsSize.width / 2, this.getCenterY() - WaystoneGui.buttonsSize.height / 2 + 46, WaystoneGui.buttonsSize.width, WaystoneGui.buttonsSize.height).m_253136_();
        this.m_142416_((GuiEventListener)this.inputBox);
        this.m_142416_((GuiEventListener)this.doneButton);
        this.inputBox.m_94202_(0xFFFFFF);
        this.inputBox.m_94205_(0xDDDDDD);
        this.inputBox.m_94199_(200);
        this.inputBox.m_94151_(name -> {
            if (this.isValid((String)name)) {
                this.inputBox.m_94202_(0xFFFFFF);
                this.inputBox.m_94205_(0xDDDDDD);
                this.doneButton.f_93623_ = true;
            } else {
                this.inputBox.m_94202_(0xFF4444);
                this.inputBox.m_94205_(0xDD6666);
                this.doneButton.f_93623_ = false;
            }
        });
        this.m_264313_((GuiEventListener)this.inputBox);
    }

    private boolean isValid(String name) {
        return this.allWaystoneNames.map(names -> !names.contains(name)).orElse(true) != false || this.oldData.isPresent() && this.oldData.get().name.equals(name);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_7379_() {
        super.m_7379_();
        WaystoneLibrary.getInstance().updateEventDispatcher.removeListener(this.waystoneUpdateListener);
    }

    private void done() {
        if (this.inputBox != null && !this.inputBox.m_94155_().equals("") && this.isValid(this.inputBox.m_94155_())) {
            WaystoneLibrary.getInstance().requestUpdate(this.inputBox.m_94155_(), new WaystoneLocationData(this.location, Vector3.fromVec3d(this.getMinecraft().f_91074_.m_20182_())), this.lockButton.m_94302_());
        }
        this.m_7379_();
    }
}

