/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.worldgen;

import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.worldgen.WaystoneDiscoveryEventListener;
import gollorum.signpost.utils.serialization.BlockPosSerializer;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.ResourceLocationSerializer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

public class VillageWaystone {
    private static final Map<BlockPos, WaystoneHandle.Vanilla> generatedWaystones = new HashMap<BlockPos, WaystoneHandle.Vanilla>();
    private static final Map<ChunkEntryKey, WaystoneHandle.Vanilla> generatedWaystonesByChunk = new HashMap<ChunkEntryKey, WaystoneHandle.Vanilla>();

    public static boolean doesWaystoneExistIn(BlockPos villageLocation) {
        return generatedWaystones.containsKey(villageLocation);
    }

    public static void register(String name, BlockPos referencePos, ServerLevel world, BlockPos blockPos) {
        WaystoneLibrary.getInstance().getHandleByName(name).ifPresent(handle -> {
            ChunkEntryKey key = new ChunkEntryKey(new ChunkPos(blockPos), world.m_46472_().m_135782_());
            generatedWaystones.put(referencePos, (WaystoneHandle.Vanilla)handle);
            generatedWaystonesByChunk.put(key, (WaystoneHandle.Vanilla)handle);
            WaystoneLibrary.getInstance().markDirty();
            WaystoneDiscoveryEventListener.registerNew(handle, world, blockPos);
        });
    }

    public static void reset() {
        generatedWaystones.clear();
        WaystoneDiscoveryEventListener.initialize();
    }

    public static Tag serialize() {
        ListTag ret = new ListTag();
        ret.addAll(generatedWaystones.entrySet().stream().map(e -> {
            CompoundTag compound = new CompoundTag();
            compound.m_128365_("refPos", (Tag)BlockPosSerializer.INSTANCE.write((BlockPos)e.getKey()));
            generatedWaystonesByChunk.entrySet().stream().filter(ce -> ((WaystoneHandle.Vanilla)ce.getValue()).equals(e.getValue())).findFirst().ifPresent(ce -> compound.m_128365_("chunkEntryKey", (Tag)ChunkEntryKey.serializer.write((ChunkEntryKey)ce.getKey())));
            compound.m_128365_("waystone", (Tag)WaystoneHandle.Vanilla.Serializer.write((WaystoneHandle.Vanilla)e.getValue()));
            return compound;
        }).toList());
        return ret;
    }

    public static void deserialize(ListTag nbt) {
        generatedWaystones.clear();
        generatedWaystones.putAll(nbt.stream().collect(Collectors.toMap(entry -> BlockPosSerializer.INSTANCE.read(((CompoundTag)entry).m_128469_("refPos")), entry -> WaystoneHandle.Vanilla.Serializer.read(((CompoundTag)entry).m_128469_("waystone")))));
        generatedWaystonesByChunk.clear();
        generatedWaystonesByChunk.putAll(nbt.stream().collect(Collectors.toMap(entry -> ChunkEntryKey.serializer.read(((CompoundTag)entry).m_128469_("chunkEntryKey")), entry -> WaystoneHandle.Vanilla.Serializer.read(((CompoundTag)entry).m_128469_("waystone")))));
    }

    public static Set<Map.Entry<BlockPos, WaystoneHandle.Vanilla>> getAllEntries(ResourceLocation dimension) {
        List<BlockPos> toRemove = generatedWaystones.entrySet().stream().filter(e -> WaystoneLibrary.getInstance().getData((WaystoneHandle.Vanilla)e.getValue()).isEmpty()).map(Map.Entry::getKey).toList();
        for (BlockPos key : toRemove) {
            generatedWaystones.remove(key);
        }
        return generatedWaystones.entrySet().stream().filter(e -> VillageWaystone.dimensionOf((WaystoneHandle.Vanilla)e.getValue()).map(d -> d.equals((Object)dimension)).orElse(true)).collect(Collectors.toSet());
    }

    private static Optional<ResourceLocation> dimensionOf(WaystoneHandle.Vanilla handle) {
        return generatedWaystonesByChunk.entrySet().stream().filter(e -> ((WaystoneHandle.Vanilla)e.getValue()).equals(handle)).findFirst().map(e -> ((ChunkEntryKey)e.getKey()).dimensionKey);
    }

    public static Map<ChunkEntryKey, WaystoneHandle.Vanilla> getAllEntriesByChunk() {
        List<ChunkEntryKey> toRemove = generatedWaystonesByChunk.entrySet().stream().filter(e -> WaystoneLibrary.getInstance().getData((WaystoneHandle.Vanilla)e.getValue()).isEmpty()).map(Map.Entry::getKey).toList();
        for (ChunkEntryKey key : toRemove) {
            generatedWaystonesByChunk.remove(key);
        }
        return generatedWaystonesByChunk;
    }

    private static List<ModelWaystone> getAllowedWaystones() {
        return ModelWaystone.variants.stream().filter(v -> Config.Server.worldGen.allowedVillageWaystones().contains(v.name)).map(v -> v.getBlock()).collect(Collectors.toList());
    }

    public static class ChunkEntryKey {
        public final ChunkPos chunkPos;
        public final ResourceLocation dimensionKey;
        public static final Serializer serializer = new Serializer();

        public ChunkEntryKey(ChunkPos chunkPos, ResourceLocation dimensionKey) {
            this.chunkPos = chunkPos;
            this.dimensionKey = dimensionKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkEntryKey that = (ChunkEntryKey)o;
            return this.chunkPos.equals((Object)that.chunkPos) && this.dimensionKey.equals((Object)that.dimensionKey);
        }

        public int hashCode() {
            return Objects.hash(this.chunkPos, this.dimensionKey);
        }

        public static class Serializer
        implements CompoundSerializable<ChunkEntryKey> {
            @Override
            public Class<ChunkEntryKey> getTargetClass() {
                return ChunkEntryKey.class;
            }

            @Override
            public CompoundTag write(ChunkEntryKey key, CompoundTag compound) {
                compound.m_128405_("x", key.chunkPos.f_45578_);
                compound.m_128405_("z", key.chunkPos.f_45579_);
                ResourceLocationSerializer.Instance.write(key.dimensionKey, compound);
                return compound;
            }

            @Override
            public boolean isContainedIn(CompoundTag compound) {
                return compound.m_128441_("x") && compound.m_128441_("z") && ResourceLocationSerializer.Instance.isContainedIn(compound);
            }

            @Override
            public ChunkEntryKey read(CompoundTag compound) {
                return new ChunkEntryKey(new ChunkPos(compound.m_128451_("x"), compound.m_128451_("z")), ResourceLocationSerializer.Instance.read(compound));
            }
        }
    }
}

