/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public interface AngleProvider {
    public static final CompoundSerializable<AngleProvider> Serializer = new CompoundSerializable<AngleProvider>(){

        @Override
        public Class<AngleProvider> getTargetClass() {
            return AngleProvider.class;
        }

        @Override
        public CompoundTag write(AngleProvider angleProvider, CompoundTag compound) {
            if (angleProvider instanceof Literal) {
                compound.m_128359_("type", "literal");
                compound.m_128365_("angle", (Tag)Angle.Serializer.write(((Literal)angleProvider).angle));
            } else if (angleProvider instanceof WaystoneTarget) {
                compound.m_128359_("type", "waystone");
                compound.m_128365_("cachedAngle", (Tag)Angle.Serializer.write(angleProvider.get()));
            } else {
                throw new RuntimeException("Invalid angle provider type " + angleProvider.getClass());
            }
            return compound;
        }

        @Override
        public boolean isContainedIn(CompoundTag compound) {
            return compound.m_128441_("type") || Angle.Serializer.isContainedIn(compound);
        }

        @Override
        public AngleProvider read(CompoundTag compound) {
            String type = compound.m_128461_("type");
            if (type.equals("literal")) {
                return new Literal(Angle.Serializer.read(compound.m_128469_("angle")));
            }
            if (type.equals("waystone")) {
                return new WaystoneTarget(Angle.Serializer.read(compound.m_128469_("cachedAngle")));
            }
            if (Angle.Serializer.isContainedIn(compound)) {
                return new Literal(Angle.Serializer.read(compound));
            }
            throw new RuntimeException("Invalid angle provider type " + type);
        }
    };

    public Angle get();

    public static AngleProvider fetchFrom(CompoundTag tag) {
        return Serializer.isContainedIn(tag) ? Serializer.read(tag) : new Literal(Angle.Serializer.read(tag));
    }

    public static final class Literal
    implements AngleProvider {
        private final Angle angle;

        public Literal(Angle angle) {
            this.angle = angle;
        }

        @Override
        public Angle get() {
            return this.angle;
        }
    }

    public static final class WaystoneTarget
    implements AngleProvider {
        private Angle cachedAngle;

        public void setCachedAngle(Angle cachedAngle) {
            this.cachedAngle = cachedAngle;
        }

        public WaystoneTarget(Angle cachedAngle) {
            this.cachedAngle = cachedAngle;
        }

        @Override
        public Angle get() {
            return this.cachedAngle;
        }
    }
}

