/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.modelGeneration;

import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.modelGeneration.FaceData;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;

public class Cube<TextureIdentifier> {
    public final Vector3 from;
    public final Vector3 to;
    public final Map<Direction, FaceData<TextureIdentifier>> sides;

    public Cube(Vector3 from, Vector3 to, Map<Direction, FaceData<TextureIdentifier>> sides) {
        this.from = from;
        this.to = to;
        this.sides = sides;
    }

    public Cube<TextureIdentifier> withSides(Function<FaceData<TextureIdentifier>, FaceData<TextureIdentifier>> func) {
        return new Cube<TextureIdentifier>(this.from, this.to, this.sides.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, kv -> (FaceData)func.apply((FaceData)kv.getValue()))));
    }

    public List<Quad<TextureIdentifier>> getQuads() {
        return this.sides.entrySet().stream().map(e -> this.getQuad((Direction)e.getKey(), (FaceData)e.getValue())).collect(Collectors.toList());
    }

    private Quad<TextureIdentifier> getQuad(Direction direction, FaceData<TextureIdentifier> faceData) {
        float fromU = faceData.textureArea().u.to;
        float toU = faceData.textureArea().u.from;
        float fromV = faceData.textureArea().v.from;
        float toV = faceData.textureArea().v.to;
        Quad<TextureIdentifier> quad = switch (direction) {
            case Direction.DOWN -> new Quad<TextureIdentifier>(new Vertex[]{new Vertex(this.from.withX(this.to.x), toU, toV), new Vertex(this.to.withY(this.from.y), toU, fromV), new Vertex(this.from.withZ(this.to.z), fromU, fromV), new Vertex(this.from, fromU, toV)}, new Vector3(0.0f, -1.0f, 0.0f), faceData);
            case Direction.UP -> new Quad<TextureIdentifier>(new Vertex[]{new Vertex(this.to.withZ(this.from.z), toU, fromV), new Vertex(this.from.withY(this.to.y), fromU, fromV), new Vertex(this.to.withX(this.from.x), fromU, toV), new Vertex(this.to, toU, toV)}, new Vector3(0.0f, 1.0f, 0.0f), faceData);
            case Direction.SOUTH -> new Quad<TextureIdentifier>(new Vertex[]{new Vertex(this.to.withY(this.from.y), fromU, toV), new Vertex(this.to, fromU, fromV), new Vertex(this.to.withX(this.from.x), toU, fromV), new Vertex(this.from.withZ(this.to.z), toU, toV)}, new Vector3(0.0f, 0.0f, 1.0f), faceData);
            case Direction.NORTH -> new Quad<TextureIdentifier>(new Vertex[]{new Vertex(this.from.withY(this.to.y), fromU, fromV), new Vertex(this.to.withZ(this.from.z), toU, fromV), new Vertex(this.from.withX(this.to.x), toU, toV), new Vertex(this.from, fromU, toV)}, new Vector3(0.0f, 0.0f, -1.0f), faceData);
            case Direction.EAST -> new Quad<TextureIdentifier>(new Vertex[]{new Vertex(this.from.withX(this.to.x), fromU, toV), new Vertex(this.to.withZ(this.from.z), fromU, fromV), new Vertex(this.to, toU, fromV), new Vertex(this.to.withY(this.from.y), toU, toV)}, new Vector3(1.0f, 0.0f, 0.0f), faceData);
            case Direction.WEST -> new Quad<TextureIdentifier>(new Vertex[]{new Vertex(this.from, toU, toV), new Vertex(this.from.withZ(this.to.z), fromU, toV), new Vertex(this.to.withX(this.from.x), fromU, fromV), new Vertex(this.from.withY(this.to.y), toU, fromV)}, new Vector3(-1.0f, 0.0f, 0.0f), faceData);
            default -> throw new RuntimeException("Direction " + direction + " could not be handled");
        };
        if (faceData.shouldFlipNormal()) {
            for (int i = 0; i < quad.vertices.length / 2; ++i) {
                Vertex temp = quad.vertices[i];
                int i2 = quad.vertices.length - i - 1;
                quad.vertices[i] = quad.vertices[i2];
                quad.vertices[i2] = temp;
            }
            return new Quad(quad.vertices, quad.normal.negated(), quad.faceData);
        }
        return quad;
    }

    public record Quad<TextureIdentifier>(Vertex[] vertices, Vector3 normal, FaceData<TextureIdentifier> faceData) {
    }

    public record Vertex(Vector3 pos, float u, float v) {
    }
}

