/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.serialization;

import gollorum.signpost.utils.serialization.BufferSerializable;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;

public class OptionalBufferSerializer<T>
implements BufferSerializable<Optional<T>> {
    private final BufferSerializable<T> valueSerializer;

    public static <T> OptionalBufferSerializer<T> from(BufferSerializable<T> valueSerializer) {
        return new OptionalBufferSerializer<T>(valueSerializer);
    }

    public OptionalBufferSerializer(BufferSerializable<T> valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    @Override
    public Class<Optional<T>> getTargetClass() {
        return Optional.empty().getClass();
    }

    @Override
    public void write(Optional<T> t, FriendlyByteBuf buffer) {
        if (t.isPresent()) {
            buffer.writeBoolean(true);
            this.valueSerializer.write(t.get(), buffer);
        } else {
            buffer.writeBoolean(false);
        }
    }

    @Override
    public Optional<T> read(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            return Optional.ofNullable(this.valueSerializer.read(buffer));
        }
        return Optional.empty();
    }
}

