/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import gollorum.signpost.Signpost;
import gollorum.signpost.minecraft.worldgen.SignpostJigsawPiece;
import gollorum.signpost.minecraft.worldgen.VillageSignpost;
import gollorum.signpost.minecraft.worldgen.VillageWaystone;
import gollorum.signpost.minecraft.worldgen.WaystoneJigsawPiece;
import gollorum.signpost.utils.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class Villages {
    public static final Villages instance = new Villages();
    private Holder<StructureProcessorList> waystoneProcessorListDesert;
    private Holder<StructureProcessorList> waystoneProcessorListPlains;
    private Holder<StructureProcessorList> waystoneProcessorListSavanna;
    private Holder<StructureProcessorList> waystoneProcessorListSnowyOrTaiga;

    private Villages() {
    }

    private void registerProcessorLists(RegistryAccess registryAccess) {
        Optional optionalReg = registryAccess.m_6632_(Registries.f_257011_);
        if (optionalReg.isEmpty()) {
            Signpost.LOGGER.error("Failed to initialize village generation: ProcessorList registry not found");
            return;
        }
        Registry reg = (Registry)optionalReg.get();
        this.waystoneProcessorListDesert = reg.m_246971_(ProcessorLists.f_127198_);
        this.waystoneProcessorListPlains = reg.m_246971_(ProcessorLists.f_127207_);
        this.waystoneProcessorListSavanna = reg.m_246971_(ProcessorLists.f_127208_);
        this.waystoneProcessorListSnowyOrTaiga = reg.m_246971_(ProcessorLists.f_127209_);
    }

    public static void reset() {
        VillageSignpost.reset();
        VillageWaystone.reset();
        SignpostJigsawPiece.reset();
        WaystoneJigsawPiece.reset();
    }

    public void initialize(RegistryAccess registryAccess) {
        this.registerProcessorLists(registryAccess);
        Optional optionalReg = registryAccess.m_6632_(Registries.f_256948_);
        if (optionalReg.isEmpty()) {
            Signpost.LOGGER.error("Failed to initialize village generation: TemplatePool registry not found");
            return;
        }
        Registry reg = (Registry)optionalReg.get();
        for (VillageType villageType : VillageType.values()) {
            this.registerFor(villageType, true, (Registry<StructureTemplatePool>)reg);
            this.registerFor(villageType, false, (Registry<StructureTemplatePool>)reg);
        }
        Villages.reset();
    }

    private void registerFor(VillageType villageType, boolean isZombie, Registry<StructureTemplatePool> registry) {
        this.addToPool((Collection<Tuple<SinglePoolElement, Integer>>)ImmutableList.of(Tuple.of(new WaystoneJigsawPiece(villageType.getWaystoneStructureResourceLocation("waystone"), villageType.processorList, StructureTemplatePool.Projection.RIGID), 1), Tuple.of(new SignpostJigsawPiece(villageType.getSignpostStructureResourceLocation("signpost"), villageType.processorList, StructureTemplatePool.Projection.TERRAIN_MATCHING, isZombie), 3)), isZombie ? Villages.getZombieVillagePool(villageType) : Villages.getVillagePool(villageType), registry);
    }

    private static ResourceLocation getVillagePool(VillageType villageType) {
        return new ResourceLocation("village/" + villageType.name + "/houses");
    }

    private static ResourceLocation getZombieVillagePool(VillageType villageType) {
        return new ResourceLocation("village/" + villageType.name + "/zombie/houses");
    }

    private void addToPool(Collection<Tuple<SinglePoolElement, Integer>> houses, ResourceLocation poolKey, Registry<StructureTemplatePool> registry) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)poolKey);
        Optional poolHolder = registry.m_203636_(key);
        if (poolHolder.isEmpty()) {
            Signpost.LOGGER.error("Tried to add elements to village pool " + poolKey + ", but it was not found in the registry.");
            return;
        }
        StructureTemplatePool pool = (StructureTemplatePool)((Holder.Reference)poolHolder.get()).get();
        ArrayList<Pair> templates = new ArrayList<Pair>(pool.f_210559_);
        for (Tuple<SinglePoolElement, Integer> tuple : houses) {
            templates.add(new Pair((Object)((StructurePoolElement)tuple._1), (Object)((Integer)tuple._2)));
            for (int i = 0; i < (Integer)tuple._2; ++i) {
                pool.f_210560_.add((Object)((StructurePoolElement)tuple._1));
            }
        }
        pool.f_210559_ = templates;
    }

    private static enum VillageType {
        Desert("desert", Villages.instance.waystoneProcessorListDesert, false),
        Plains("plains", Villages.instance.waystoneProcessorListPlains, true),
        Savanna("savanna", Villages.instance.waystoneProcessorListSavanna, true),
        Snowy("snowy", Villages.instance.waystoneProcessorListSnowyOrTaiga, true),
        Taiga("taiga", Villages.instance.waystoneProcessorListSnowyOrTaiga, true);

        public final String name;
        public final Holder<StructureProcessorList> processorList;
        public final boolean isCommonGround;

        private VillageType(String name, Holder<StructureProcessorList> processorList, boolean isCommonGround) {
            this.name = name;
            this.processorList = processorList;
            this.isCommonGround = isCommonGround;
        }

        public ResourceLocation getSignpostStructureResourceLocation(String structureName) {
            return new ResourceLocation("signpost", "village/" + this.name + "/" + structureName);
        }

        public ResourceLocation getWaystoneStructureResourceLocation(String structureName) {
            return new ResourceLocation("signpost", "village/" + (this.isCommonGround ? "common" : this.name) + "/" + structureName);
        }
    }
}

