/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.misc.structurepiececounter;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.misc.structurepiececounter.StructurePieceCountsAdditionsMerger;
import com.craisinlord.integrated_api.misc.structurepiececounter.StructurePieceCountsObj;
import com.craisinlord.integrated_api.modinit.IAConditionsRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;

public class StructurePieceCountsManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    public static final StructurePieceCountsManager STRUCTURE_PIECE_COUNTS_MANAGER = new StructurePieceCountsManager();
    private Map<ResourceLocation, List<StructurePieceCountsObj>> StructureToPieceCountsObjs = new HashMap<ResourceLocation, List<StructurePieceCountsObj>>();
    private final Map<ResourceLocation, Map<ResourceLocation, RequiredPieceNeeds>> cachedRequirePiecesMap = new HashMap<ResourceLocation, Map<ResourceLocation, RequiredPieceNeeds>>();
    private final Map<ResourceLocation, Map<ResourceLocation, Integer>> cachedMaxCountPiecesMap = new HashMap<ResourceLocation, Map<ResourceLocation, Integer>>();

    public StructurePieceCountsManager() {
        super(GSON, "integrated_pieces_spawn_counts");
    }

    @MethodsReturnNonnullByDefault
    private List<StructurePieceCountsObj> getStructurePieceCountsObjs(ResourceLocation fileIdentifier, JsonElement jsonElement) throws Exception {
        List piecesSpawnCounts = (List)GSON.fromJson(jsonElement.getAsJsonObject().get("integrated_pieces_spawn_counts"), new TypeToken<List<StructurePieceCountsObj>>(){}.getType());
        for (int i = piecesSpawnCounts.size() - 1; i >= 0; --i) {
            Supplier<Boolean> supplier;
            StructurePieceCountsObj entry = (StructurePieceCountsObj)piecesSpawnCounts.get(i);
            if (entry.alwaysSpawnThisMany != null && entry.neverSpawnMoreThanThisMany != null && entry.alwaysSpawnThisMany > entry.neverSpawnMoreThanThisMany) {
                throw new Exception("Integrated API Error: Found " + entry.nbtPieceName + " entry has alwaysSpawnThisMany greater than neverSpawnMoreThanThisMany which is invalid.");
            }
            if (entry.condition == null || (supplier = IAConditionsRegistry.IA_JSON_CONDITIONS_REGISTRY.lookup().get(new ResourceLocation(entry.condition))) == null || supplier.get().booleanValue()) continue;
            piecesSpawnCounts.remove(entry);
        }
        return piecesSpawnCounts;
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, List<StructurePieceCountsObj>> mapBuilder = new HashMap<ResourceLocation, List<StructurePieceCountsObj>>();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                mapBuilder.put((ResourceLocation)fileIdentifier, this.getStructurePieceCountsObjs((ResourceLocation)fileIdentifier, (JsonElement)jsonElement));
            }
            catch (Exception e) {
                IntegratedAPI.LOGGER.error("Integrated API Error: Couldn't parse integrated_pieces_spawn_counts file {} - JSON looks like: {}", fileIdentifier, jsonElement, (Object)e);
            }
        });
        this.StructureToPieceCountsObjs = mapBuilder;
        this.cachedRequirePiecesMap.clear();
        StructurePieceCountsAdditionsMerger.performCountsAdditionsDetectionAndMerger(manager);
    }

    public void parseAndAddCountsJSONObj(ResourceLocation structureRL, List<JsonElement> jsonElements) {
        jsonElements.forEach(jsonElement -> {
            try {
                this.StructureToPieceCountsObjs.computeIfAbsent(structureRL, rl -> new ArrayList()).addAll(this.getStructurePieceCountsObjs(structureRL, (JsonElement)jsonElement));
            }
            catch (Exception e) {
                IntegratedAPI.LOGGER.error("Integrated API Error: Couldn't parse integrated_pieces_spawn_counts file {} - JSON looks like: {}", (Object)structureRL, jsonElement, (Object)e);
            }
        });
    }

    @Nullable
    public Map<ResourceLocation, RequiredPieceNeeds> getRequirePieces(ResourceLocation structureRL) {
        if (!this.StructureToPieceCountsObjs.containsKey(structureRL)) {
            return null;
        }
        if (this.cachedRequirePiecesMap.containsKey(structureRL)) {
            return this.cachedRequirePiecesMap.get(structureRL);
        }
        HashMap<ResourceLocation, RequiredPieceNeeds> requirePiecesMap = new HashMap<ResourceLocation, RequiredPieceNeeds>();
        List<StructurePieceCountsObj> structurePieceCountsObjs = this.StructureToPieceCountsObjs.get(structureRL);
        if (structurePieceCountsObjs != null) {
            structurePieceCountsObjs.forEach(entry -> {
                if (entry.alwaysSpawnThisMany != null) {
                    requirePiecesMap.put(new ResourceLocation(entry.nbtPieceName), new RequiredPieceNeeds(entry.alwaysSpawnThisMany, entry.minimumDistanceFromCenterPiece != null ? entry.minimumDistanceFromCenterPiece : 0));
                }
            });
        }
        this.cachedRequirePiecesMap.put(structureRL, requirePiecesMap);
        return requirePiecesMap;
    }

    @MethodsReturnNonnullByDefault
    public Map<ResourceLocation, Integer> getMaximumCountForPieces(ResourceLocation structureRL) {
        if (this.cachedMaxCountPiecesMap.containsKey(structureRL)) {
            return this.cachedMaxCountPiecesMap.get(structureRL);
        }
        HashMap<ResourceLocation, Integer> maxCountPiecesMap = new HashMap<ResourceLocation, Integer>();
        List<StructurePieceCountsObj> structurePieceCountsObjs = this.StructureToPieceCountsObjs.get(structureRL);
        if (structurePieceCountsObjs != null) {
            structurePieceCountsObjs.forEach(entry -> {
                if (entry.neverSpawnMoreThanThisMany != null) {
                    maxCountPiecesMap.put(new ResourceLocation(entry.nbtPieceName), entry.neverSpawnMoreThanThisMany);
                }
            });
        }
        this.cachedMaxCountPiecesMap.put(structureRL, maxCountPiecesMap);
        return maxCountPiecesMap;
    }

    public record RequiredPieceNeeds(int maxLimit, int minDistanceFromCenter) {
        public int getRequiredAmount() {
            return this.maxLimit;
        }

        public int getMinDistanceFromCenter() {
            return this.minDistanceFromCenter;
        }
    }
}

