/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.condition;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.world.condition.StructureCondition;
import com.craisinlord.integrated_api.world.condition.StructureConditionType;
import com.craisinlord.integrated_api.world.structures.context.StructureContext;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.level.block.Rotation;

public class RotationCondition
extends StructureCondition {
    public static final Codec<RotationCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Rotation.f_221983_.listOf().fieldOf("rotations").forGetter(conditon -> conditon.validRotations)).apply((Applicative)builder, RotationCondition::new));
    private final List<Rotation> validRotations;

    public RotationCondition(List<Rotation> validRotations) {
        this.validRotations = validRotations;
    }

    @Override
    public StructureConditionType<?> type() {
        return StructureConditionType.ROTATION;
    }

    @Override
    public boolean passes(StructureContext ctx) {
        Rotation rotation = ctx.rotation();
        if (rotation == null) {
            IntegratedAPI.LOGGER.error("Missing required field 'rotation' for rotation condition!");
        }
        if (rotation == null) {
            return false;
        }
        return this.validRotations.contains(rotation);
    }
}

