/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.structures;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.modinit.IAStructures;
import com.craisinlord.integrated_api.world.structures.JigsawStructure;
import com.craisinlord.integrated_api.world.structures.pieces.manager.PieceLimitedJigsawManager;
import com.craisinlord.integrated_api.world.terrainadaptation.EnhancedTerrainAdaptation;
import com.craisinlord.integrated_api.world.terrainadaptation.EnhancedTerrainAdaptationType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class BiomeFacingStructure
extends JigsawStructure {
    public static final Codec<BiomeFacingStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeFacingStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.optionalFieldOf("min_y_allowed").forGetter(structure -> structure.minYAllowed), (App)Codec.INT.optionalFieldOf("max_y_allowed").forGetter(structure -> structure.maxYAllowed), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_y_range_from_start").forGetter(structure -> structure.allowedYRangeFromStart), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("terrain_height_radius_check").forGetter(structure -> structure.terrainHeightCheckRadius), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_terrain_height_range").forGetter(structure -> structure.allowedTerrainHeightRange), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)Codec.intRange((int)1, (int)512).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)EnhancedTerrainAdaptationType.ADAPTATION_CODEC.optionalFieldOf("enhanced_terrain_adaptation", (Object)EnhancedTerrainAdaptation.NONE).forGetter(structure -> structure.enhancedTerrainAdaptation), (App)Codec.intRange((int)1, (int)100).fieldOf("target_biome_radius_check_blocks").orElse((Object)24).forGetter(structure -> structure.targetBiomeRadius), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256952_).fieldOf("target_biomes").forGetter(structure -> structure.targetBiomes)).apply((Applicative)instance, BiomeFacingStructure::new));
    private final int targetBiomeRadius;
    private final HolderSet<Biome> targetBiomes;

    public BiomeFacingStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, Optional<Integer> minYAllowed, Optional<Integer> maxYAllowed, Optional<Integer> allowedYRangeFromStart, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, boolean cannotSpawnInLiquid, Optional<Integer> terrainHeightCheckRadius, Optional<Integer> allowedTerrainHeightRange, Optional<Integer> biomeRadius, Optional<Integer> maxDistanceFromCenter, EnhancedTerrainAdaptation enhancedTerrainAdaptation, int targetBiomeRadius, HolderSet<Biome> targetBiomes) {
        super(config, startPool, size, minYAllowed, maxYAllowed, allowedYRangeFromStart, startHeight, projectStartToHeightmap, cannotSpawnInLiquid, terrainHeightCheckRadius, allowedTerrainHeightRange, biomeRadius, maxDistanceFromCenter, Optional.empty(), false, enhancedTerrainAdaptation);
        this.targetBiomeRadius = targetBiomeRadius;
        this.targetBiomes = targetBiomes;
    }

    private String rotationToBiome(BlockPos blockpos, Structure.GenerationContext context) {
        int validBiomeRange = this.targetBiomeRadius;
        int sectionY = blockpos.m_123342_();
        if (this.projectStartToHeightmap.isPresent()) {
            sectionY += context.f_226622_().m_223235_(blockpos.m_123341_(), blockpos.m_123343_(), (Heightmap.Types)this.projectStartToHeightmap.get(), context.f_226629_(), context.f_226624_());
        }
        sectionY = QuartPos.m_175400_((int)sectionY);
        int posZ = blockpos.m_123343_();
        int posX = blockpos.m_123341_();
        int sectionBiomeRange = (int)Math.ceil(validBiomeRange / 4) + 2;
        Set section2Biomes = context.f_226623_().m_183399_(posX - sectionBiomeRange, sectionY, posZ - 2 * sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Object biome : section2Biomes) {
            if (!this.targetBiomes.m_203333_((Holder)biome)) continue;
            return "NONE";
        }
        Set section3Biomes = context.f_226623_().m_183399_(posX + sectionBiomeRange, sectionY, posZ - 2 * sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Object biome : section3Biomes) {
            if (!this.targetBiomes.m_203333_((Holder)biome)) continue;
            return "NONE";
        }
        Set section12Biomes = context.f_226623_().m_183399_(posX + 2 * sectionBiomeRange, sectionY, posZ + sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Object biome : section12Biomes) {
            if (!this.targetBiomes.m_203333_((Holder)biome)) continue;
            return "CLOCKWISE_90";
        }
        Set section8Biomes = context.f_226623_().m_183399_(posX + 2 * sectionBiomeRange, sectionY, posZ - sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Object biome : section8Biomes) {
            if (!this.targetBiomes.m_203333_((Holder)biome)) continue;
            return "CLOCKWISE_90";
        }
        Set section14Biomes = context.f_226623_().m_183399_(posX - sectionBiomeRange, sectionY, posZ + 2 * sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Object biome : section14Biomes) {
            if (!this.targetBiomes.m_203333_((Holder)biome)) continue;
            return "CLOCKWISE_180";
        }
        Set section15Biomes = context.f_226623_().m_183399_(posX + sectionBiomeRange, sectionY, posZ + 2 * sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Object biome : section15Biomes) {
            if (!this.targetBiomes.m_203333_((Holder)biome)) continue;
            return "CLOCKWISE_180";
        }
        Set section5Biomes = context.f_226623_().m_183399_(posX - 2 * sectionBiomeRange, sectionY, posZ - sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Object biome : section5Biomes) {
            if (!this.targetBiomes.m_203333_((Holder)biome)) continue;
            return "COUNTERCLOCKWISE_90";
        }
        Set section9Biomes = context.f_226623_().m_183399_(posX - 2 * sectionBiomeRange, sectionY, posZ + sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Object biome : section9Biomes) {
            if (!this.targetBiomes.m_203333_((Holder)biome)) continue;
            return "COUNTERCLOCKWISE_90";
        }
        Set section6Biomes = context.f_226623_().m_183399_(posX - sectionBiomeRange, sectionY, posZ - sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Object biome : section6Biomes) {
            if (!this.targetBiomes.m_203333_((Holder)biome)) continue;
            return "COUNTERCLOCKWISE_90";
        }
        Set section7Biomes = context.f_226623_().m_183399_(posX + sectionBiomeRange, sectionY, posZ - sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Object biome : section7Biomes) {
            if (!this.targetBiomes.m_203333_((Holder)biome)) continue;
            return "CLOCKWISE_90";
        }
        Set section11Biomes = context.f_226623_().m_183399_(posX + sectionBiomeRange, sectionY, posZ + sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Object biome : section11Biomes) {
            if (!this.targetBiomes.m_203333_((Holder)biome)) continue;
            return "CLOCKWISE_90";
        }
        Set section10Biomes = context.f_226623_().m_183399_(posX - sectionBiomeRange, sectionY, posZ + sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Object biome : section10Biomes) {
            if (!this.targetBiomes.m_203333_((Holder)biome)) continue;
            return "COUNTERCLOCKWISE_90";
        }
        Set section1Biomes = context.f_226623_().m_183399_(posX - 2 * sectionBiomeRange, sectionY, posZ - 2 * sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Object biome : section1Biomes) {
            if (!this.targetBiomes.m_203333_((Holder)biome)) continue;
            return "NONE";
        }
        Set section4Biomes = context.f_226623_().m_183399_(posX + 2 * sectionBiomeRange, sectionY, posZ - 2 * sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Object biome : section4Biomes) {
            if (!this.targetBiomes.m_203333_((Holder)biome)) continue;
            return "NONE";
        }
        Set section16Biomes = context.f_226623_().m_183399_(posX + 2 * sectionBiomeRange, sectionY, posZ + 2 * sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Holder biome : section16Biomes) {
            if (!this.targetBiomes.m_203333_(biome)) continue;
            return "CLOCKWISE_180";
        }
        Set section13Biomes = context.f_226623_().m_183399_(posX - 2 * sectionBiomeRange, sectionY, posZ + 2 * sectionBiomeRange, sectionBiomeRange, context.f_226624_().m_224579_());
        for (Holder biome : section13Biomes) {
            if (!this.targetBiomes.m_203333_(biome)) continue;
            return "CLOCKWISE_180";
        }
        IntegratedAPI.LOGGER.info("EVIL DETECTED YOU WILL BE EXTERMINATED");
        return "NONE";
    }

    private boolean checkBiome(BlockPos blockpos, Structure.GenerationContext context) {
        int validBiomeRange = this.targetBiomeRadius - 4;
        int sectionY = blockpos.m_123342_();
        if (this.projectStartToHeightmap.isPresent()) {
            sectionY += context.f_226622_().m_223235_(blockpos.m_123341_(), blockpos.m_123343_(), (Heightmap.Types)this.projectStartToHeightmap.get(), context.f_226629_(), context.f_226624_());
        }
        sectionY = QuartPos.m_175400_((int)sectionY);
        int posZ = blockpos.m_123343_();
        int posX = blockpos.m_123341_();
        for (Holder biome : context.f_226623_().m_183399_(posX, sectionY, posZ, validBiomeRange, context.f_226624_().m_224579_())) {
            if (!this.targetBiomes.m_203333_(biome)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean extraSpawningChecks(Structure.GenerationContext context, BlockPos blockPos) {
        ChunkPos chunkPos = context.f_226628_();
        if (this.biomeRadius.isPresent() && !(context.f_226623_() instanceof CheckerboardColumnBiomeSource)) {
            int validBiomeRange = (Integer)this.biomeRadius.get();
            int sectionY = blockPos.m_123342_();
            if (this.projectStartToHeightmap.isPresent()) {
                sectionY += context.f_226622_().m_223235_(blockPos.m_123341_(), blockPos.m_123343_(), (Heightmap.Types)this.projectStartToHeightmap.get(), context.f_226629_(), context.f_226624_());
            }
            sectionY = QuartPos.m_175400_((int)sectionY);
            for (int curChunkX = chunkPos.f_45578_ - validBiomeRange; curChunkX <= chunkPos.f_45578_ + validBiomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - validBiomeRange; curChunkZ <= chunkPos.f_45579_ + validBiomeRange; ++curChunkZ) {
                    Holder biome = context.f_226623_().m_203407_(QuartPos.m_175404_((int)curChunkX), sectionY, QuartPos.m_175404_((int)curChunkZ), context.f_226624_().m_224579_());
                    if (context.f_226630_().test(biome)) continue;
                    return false;
                }
            }
        }
        if (!this.checkBiome(blockPos, context)) {
            return false;
        }
        if (this.cannotSpawnInLiquid) {
            BlockPos centerOfChunk = chunkPos.m_151394_(0);
            int landHeight = context.f_226622_().m_223235_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
            NoiseColumn columnOfBlocks = context.f_226622_().m_214184_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), context.f_226629_(), context.f_226624_());
            BlockState topBlock = columnOfBlocks.m_183556_(centerOfChunk.m_123342_() + landHeight);
            if (!topBlock.m_60819_().m_76178_()) {
                return false;
            }
        }
        if (this.terrainHeightCheckRadius.isPresent() && (this.allowedTerrainHeightRange.isPresent() || this.minYAllowed.isPresent())) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            int terrainCheckRange = (Integer)this.terrainHeightCheckRadius.get();
            for (int curChunkX = chunkPos.f_45578_ - terrainCheckRange; curChunkX <= chunkPos.f_45578_ + terrainCheckRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - terrainCheckRange; curChunkZ <= chunkPos.f_45579_ + terrainCheckRange; ++curChunkZ) {
                    int height = context.f_226622_().m_214096_((curChunkX << 4) + 7, (curChunkZ << 4) + 7, this.projectStartToHeightmap.orElse(Heightmap.Types.WORLD_SURFACE_WG), context.f_226629_(), context.f_226624_());
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    minTerrainHeight = Math.min(minTerrainHeight, height);
                    if (this.minYAllowed.isPresent() && minTerrainHeight < (Integer)this.minYAllowed.get()) {
                        return false;
                    }
                    if (!this.maxYAllowed.isPresent() || minTerrainHeight <= (Integer)this.maxYAllowed.get()) continue;
                    return false;
                }
            }
            if (this.allowedTerrainHeightRange.isPresent() && maxTerrainHeight - minTerrainHeight > (Integer)this.allowedTerrainHeightRange.get()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        String rotationString;
        int offsetY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos blockpos = new BlockPos(context.f_226628_().m_45604_(), offsetY, context.f_226628_().m_45605_());
        if (!this.extraSpawningChecks(context, blockpos)) {
            return Optional.empty();
        }
        int topClipOff = Integer.MAX_VALUE;
        int bottomClipOff = Integer.MIN_VALUE;
        if (this.allowedYRangeFromStart.isPresent()) {
            topClipOff = blockpos.m_123342_() + (Integer)this.allowedYRangeFromStart.get();
            bottomClipOff = blockpos.m_123342_() - (Integer)this.allowedYRangeFromStart.get();
        }
        if (this.maxYAllowed.isPresent()) {
            topClipOff = Math.min(topClipOff, (Integer)this.maxYAllowed.get());
        }
        if (this.minYAllowed.isPresent()) {
            bottomClipOff = Math.max(bottomClipOff, (Integer)this.minYAllowed.get());
        }
        if ((rotationString = this.rotationToBiome(blockpos, context)) == null) {
            throw new RuntimeException(new Exception("Integrated API Found Null Rotation for Biome Facing Structure. REPORT THIS TO CRAISIN!"));
        }
        int finalTopClipOff = topClipOff;
        int finalBottomClipOff = bottomClipOff;
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, (Holder<StructureTemplatePool>)this.startPool, this.size, context.f_226621_().m_175515_(Registries.f_256944_).m_7981_((Object)this), blockpos, false, this.projectStartToHeightmap, topClipOff, bottomClipOff, null, this.maxDistanceFromCenter, rotationString, this.buryingType, (structurePiecesBuilder, pieces) -> this.postLayoutAdjustments((StructurePiecesBuilder)structurePiecesBuilder, context, offsetY, blockpos, finalTopClipOff, finalBottomClipOff, (List<PoolElementStructurePiece>)pieces));
    }

    @Override
    public StructureType<?> m_213658_() {
        return IAStructures.BIOME_FACING_STRUCTURE.get();
    }
}

