/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal;

import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.SandSnapperEntity;
import com.yungnickyoung.minecraft.yungscavebiomes.module.ItemModule;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.ISandstormServerDataProvider;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.SandstormServerData;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class EatPeachGoal
extends Goal {
    private final SandSnapperEntity sandSnapper;
    private final float horizontalRange;
    private final float verticalRange;
    private final float playerDist;
    private final float eatRange;
    private ItemEntity peachItem;
    private int eatingTimer;
    private static final int EAT_LENGTH = 31;

    public EatPeachGoal(SandSnapperEntity sandSnapper, float horizontalRange, float verticalRange, float playerDist, float eatRange) {
        this.sandSnapper = sandSnapper;
        this.horizontalRange = horizontalRange;
        this.verticalRange = verticalRange;
        this.playerDist = playerDist;
        this.eatRange = eatRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public void m_8056_() {
        this.sandSnapper.setSubmerged(false);
        this.sandSnapper.setSubmergeLocked(true);
        this.sandSnapper.m_21573_().m_5624_((Entity)this.peachItem, 1.0);
    }

    public void m_8041_() {
        this.sandSnapper.setEating(false);
        this.sandSnapper.setSubmergeLocked(false);
    }

    public void m_8037_() {
        if (this.sandSnapper.m_20270_((Entity)this.peachItem) > this.eatRange && this.sandSnapper.m_21573_().m_26571_()) {
            if (this.sandSnapper.isEating()) {
                this.sandSnapper.setEating(false);
            }
            this.sandSnapper.m_21573_().m_5624_((Entity)this.peachItem, 1.0);
        } else if (this.sandSnapper.m_20270_((Entity)this.peachItem) <= this.eatRange && !this.sandSnapper.isEating()) {
            this.sandSnapper.setEating(true);
            this.eatingTimer = 31;
        }
        if (this.sandSnapper.isEating()) {
            --this.eatingTimer;
            if (this.eatingTimer <= 0) {
                this.sandSnapper.setEating(false);
                this.peachItem.m_146870_();
                this.sandSnapper.onEat();
            }
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8036_() {
        List itemsNearby = this.sandSnapper.m_9236_().m_6443_(ItemEntity.class, this.sandSnapper.m_20191_().m_82377_((double)this.horizontalRange, (double)this.verticalRange, (double)this.horizontalRange), entity -> entity.m_32055_().m_150930_((Item)ItemModule.PRICKLY_PEACH_ITEM.get()));
        if (itemsNearby.isEmpty()) {
            return false;
        }
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.m_9236_()).getSandstormServerData();
        Collections.shuffle(itemsNearby);
        if (!sandstormServerData.isSandstormActive()) {
            for (ItemEntity item : itemsNearby) {
                Player nearestPlayer = item.m_9236_().m_45924_(item.m_20185_(), item.m_20186_(), item.m_20189_(), (double)this.playerDist, true);
                if (nearestPlayer != null) continue;
                this.peachItem = item;
                return true;
            }
        } else {
            this.peachItem = (ItemEntity)itemsNearby.get(0);
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.peachItem.m_213877_()) {
            return false;
        }
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.m_9236_()).getSandstormServerData();
        if (!sandstormServerData.isSandstormActive()) {
            Player nearestPlayer = this.peachItem.m_9236_().m_45924_(this.peachItem.m_20185_(), this.peachItem.m_20186_(), this.peachItem.m_20189_(), (double)this.playerDist, true);
            return nearestPlayer == null;
        }
        return true;
    }
}

