/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.ElevatorBaseBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.ElevatorCallerBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.inventory.ElevatorMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketServerTickTime;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ElevatorBaseBlockEntity
extends AbstractAirHandlingBlockEntity
implements IGUITextFieldSensitive,
IRedstoneControl<ElevatorBaseBlockEntity>,
IMinWorkingPressure,
CamouflageableBlockEntity,
MenuProvider {
    private static final List<RedstoneController.RedstoneMode<ElevatorBaseBlockEntity>> REDSTONE_LABELS = ImmutableList.of(new RedstoneController.ReceivingRedstoneMode<ElevatorBaseBlockEntity>("elevator.redstone", new ItemStack((ItemLike)Items.f_42451_), te -> true), new RedstoneController.ReceivingRedstoneMode<ElevatorBaseBlockEntity>("elevator.caller", new ItemStack((ItemLike)ModBlocks.ELEVATOR_CALLER.get()), te -> true));
    private static final float BUTTON_MARGIN = 0.2f;
    private static final float BUTTON_HEIGHT = 0.06f;
    private static final float BUTTON_SPACING = 0.02f;
    private static final int MAX_BUTTONS_PER_ROW = 9;
    private static final byte RS_REDSTONE_MODE = 0;
    private static final byte RS_CALLER_MODE = 1;
    @DescSynced
    @LazySynced
    public double extension;
    @DescSynced
    private double targetExtension;
    @DescSynced
    double syncedSpeedMult;
    @DescSynced
    public int multiElevatorCount;
    @GuiSynced
    private final RedstoneController<ElevatorBaseBlockEntity> rsController = new RedstoneController<ElevatorBaseBlockEntity>(this, REDSTONE_LABELS);
    @GuiSynced
    private int maxFloorHeight;
    @DescSynced
    private int chargingUpgrades;
    public double oldExtension;
    private boolean isStopped = true;
    private ElevatorBaseBlockEntity coreElevator;
    private List<ElevatorBaseBlockEntity> multiElevators;
    public int[] floorHeights = new int[0];
    private Int2ObjectMap<String> floorNames = new Int2ObjectOpenHashMap();
    private int redstoneInputLevel;
    private BlockState camoState;
    private BlockState prevCamoState;
    public int ticksRunning;
    private final IntList floorList = new IntArrayList();
    private final List<BlockPos> callerList = new ArrayList<BlockPos>();
    private long lastFloorUpdate = 0L;
    public float[] fakeFloorTextureUV;
    public int lightAbove;

    public ElevatorBaseBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ELEVATOR_BASE.get(), pos, state, PressureTier.TIER_ONE, 10000, 4);
    }

    @Override
    public void tickCommonPre() {
        double speedMultiplier;
        this.oldExtension = this.extension;
        super.tickCommonPre();
        if (!this.isCoreElevator()) {
            this.extension = 0.0;
            return;
        }
        if (!this.nonNullLevel().f_46443_) {
            if (this.isControlledByRedstone()) {
                this.handleRedstoneControl();
            }
            speedMultiplier = this.syncedSpeedMult = (double)this.getSpeedMultiplierFromUpgrades();
            this.chargingUpgrades = this.getUpgrades(ModUpgrades.CHARGING.get());
        } else {
            speedMultiplier = (float)(this.syncedSpeedMult * PacketServerTickTime.tickTimeMultiplier);
            if (this.prevCamoState != this.camoState) {
                this.fakeFloorTextureUV = ClientUtils.getTextureUV(this.camoState, Direction.UP);
                this.prevCamoState = this.camoState;
            }
            if ((this.nonNullLevel().m_46467_() & 0xFL) == 0L) {
                this.lightAbove = ClientUtils.getLightAt(this.f_58858_.m_7494_());
            }
        }
        if (this.extension < this.targetExtension) {
            if (!this.nonNullLevel().f_46443_ && this.getPressure() < 3.0f) {
                this.targetExtension = this.extension;
            }
            double moveBy = this.extension < this.targetExtension - 0.5 ? (double)0.05f * speedMultiplier : (double)0.02f * speedMultiplier;
            this.extension = Math.min(this.targetExtension, this.extension + moveBy);
            this.addAir((int)((this.oldExtension - this.extension) * 300.0 * ((double)this.getSpeedUsageMultiplierFromUpgrades() / speedMultiplier)));
        } else if (this.extension > this.targetExtension) {
            double chargingSlowdown = 1.0 - (double)this.chargingUpgrades * 0.1;
            double moveBy = this.extension > this.targetExtension + 0.5 ? (double)0.05f * speedMultiplier * chargingSlowdown : (double)0.02f * speedMultiplier * chargingSlowdown;
            this.extension = Math.max(this.targetExtension, this.extension - moveBy);
            if (!this.nonNullLevel().f_46443_ && this.chargingUpgrades > 0 && this.getPressure() < this.airHandler.getDangerPressure() - 0.1f) {
                float mul = 0.15f * (float)Math.min(4, this.chargingUpgrades);
                this.addAir((int)((this.oldExtension - this.extension) * 300.0 * (double)mul * ((double)this.getSpeedUsageMultiplierFromUpgrades() / speedMultiplier)));
            }
        }
        if (PneumaticCraftUtils.epsilonEquals(this.oldExtension, this.extension) && !this.isStopped) {
            this.isStopped = true;
            this.ticksRunning = 0;
            this.playStopStartSound();
            if (!this.nonNullLevel().f_46443_) {
                this.updateFloors(false);
            }
        } else if (!PneumaticCraftUtils.epsilonEquals(this.oldExtension, this.extension) && this.isStopped) {
            this.isStopped = false;
            this.playStopStartSound();
        }
        if (!this.isStopped) {
            ++this.ticksRunning;
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.connectAsMultiblock();
    }

    private void playStopStartSound() {
        if (this.shouldPlaySounds()) {
            if (this.nonNullLevel().m_5776_()) {
                this.nonNullLevel().m_7785_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + this.extension, (double)this.m_58899_().m_123343_() + 0.5, this.isStopped ? (SoundEvent)ModSounds.ELEVATOR_RISING_STOP.get() : (SoundEvent)ModSounds.ELEVATOR_RISING_START.get(), SoundSource.BLOCKS, ((Double)ConfigHelper.client().sound.elevatorVolumeStartStop.get()).floatValue(), 1.0f, true);
            } else if (!this.isStopped) {
                NetworkHandler.sendToAllTracking((Object)new PacketPlayMovingSound(MovingSounds.Sound.ELEVATOR, PacketPlayMovingSound.MovingSoundFocus.of(this.getCoreElevator())), this);
            }
        }
    }

    private boolean shouldPlaySounds() {
        return !(this.getCachedNeighbor(Direction.EAST) instanceof ElevatorBaseBlockEntity) && !(this.getCachedNeighbor(Direction.SOUTH) instanceof ElevatorBaseBlockEntity);
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    private void handleRedstoneControl() {
        double oldTargetExtension = this.targetExtension;
        float maxExtension = this.getMaxElevatorHeight();
        int redstoneInput = this.redstoneInputLevel;
        if (this.multiElevators != null) {
            for (ElevatorBaseBlockEntity base : this.multiElevators) {
                redstoneInput = Math.max(this.redstoneInputLevel, base.redstoneInputLevel);
            }
        }
        this.targetExtension = (float)redstoneInput * maxExtension / 15.0f;
        if (this.targetExtension > this.oldExtension && this.getPressure() < 3.0f) {
            this.targetExtension = this.oldExtension;
        }
        if (oldTargetExtension != this.targetExtension) {
            this.sendDescPacketFromAllElevators();
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public void onRedstoneModeChanged(int newModeIdx) {
        if (this.multiElevators != null) {
            for (ElevatorBaseBlockEntity base : this.multiElevators) {
                base.getRedstoneController().setCurrentMode(newModeIdx);
            }
        }
        int i = -1;
        BlockEntity te = this.nonNullLevel().m_7702_(this.m_58899_().m_121945_(Direction.DOWN));
        while (te instanceof ElevatorBaseBlockEntity) {
            ElevatorBaseBlockEntity elevator = (ElevatorBaseBlockEntity)te;
            elevator.getRedstoneController().setCurrentMode(newModeIdx);
            te = this.nonNullLevel().m_7702_(this.m_58899_().m_7918_(0, --i, 0));
        }
    }

    private boolean isControlledByRedstone() {
        return this.getRedstoneController().getCurrentMode() == 0;
    }

    private void updateRedstoneInputLevel() {
        if (this.multiElevators == null) {
            return;
        }
        int maxRedstone = this.getMaxRedstone();
        for (ElevatorBaseBlockEntity base : this.multiElevators) {
            base.redstoneInputLevel = maxRedstone;
        }
    }

    private int getMaxRedstone() {
        int maxRedstone = 0;
        for (ElevatorBaseBlockEntity base : this.multiElevators) {
            BlockPos.MutableBlockPos pos1 = base.m_58899_().m_122032_();
            while (this.nonNullLevel().m_8055_((BlockPos)pos1).m_60734_() == ModBlocks.ELEVATOR_BASE.get()) {
                if ((maxRedstone = Math.max(maxRedstone, this.nonNullLevel().m_277086_((BlockPos)pos1))) == 15) {
                    return 15;
                }
                pos1.m_122173_(Direction.DOWN);
            }
        }
        return maxRedstone;
    }

    public float getMaxElevatorHeight() {
        int max = this.maxFloorHeight;
        if (this.multiElevators != null) {
            for (ElevatorBaseBlockEntity base : this.multiElevators) {
                max = Math.min(max, base.maxFloorHeight);
            }
        }
        return max;
    }

    public void updateMaxElevatorHeight() {
        int i = -1;
        while (this.nonNullLevel().m_8055_(this.m_58899_().m_7918_(0, ++i + 1, 0)).m_60734_() == ModBlocks.ELEVATOR_FRAME.get()) {
        }
        int elevatorBases = 0;
        while (this.nonNullLevel().m_8055_(this.m_58899_().m_7918_(0, -(++elevatorBases), 0)).m_60734_() == ModBlocks.ELEVATOR_BASE.get()) {
        }
        this.maxFloorHeight = Math.min(i, elevatorBases * (Integer)ConfigHelper.common().machines.elevatorBaseBlocksPerBase.get());
        this.m_6596_();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("extensionD")) {
            this.extension = tag.m_128459_("extensionD");
            this.targetExtension = tag.m_128459_("targetExtensionD");
        } else {
            this.extension = tag.m_128457_("extension");
            this.targetExtension = tag.m_128457_("targetExtension");
        }
        if (!tag.m_128441_("maxFloorHeight")) {
            this.updateMaxElevatorHeight();
        } else {
            this.maxFloorHeight = tag.m_128451_("maxFloorHeight");
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128347_("extensionD", this.extension);
        tag.m_128347_("targetExtensionD", this.targetExtension);
        tag.m_128405_("maxFloorHeight", this.maxFloorHeight);
    }

    @Override
    public void readFromPacket(CompoundTag tag) {
        super.readFromPacket(tag);
        this.camoState = CamouflageableBlockEntity.readCamo(tag);
        this.floorHeights = tag.m_128465_("floorHeights");
        this.floorNames.clear();
        ListTag floorNameList = tag.m_128437_("floorNames", 10);
        for (int i = 0; i < floorNameList.size(); ++i) {
            CompoundTag floorName = floorNameList.m_128728_(i);
            this.floorNames.put(floorName.m_128451_("floorHeight"), (Object)floorName.m_128461_("floorName"));
        }
    }

    @Override
    public void writeToPacket(CompoundTag tag) {
        super.writeToPacket(tag);
        CamouflageableBlockEntity.writeCamo(tag, this.camoState);
        tag.m_128385_("floorHeights", this.floorHeights);
        ListTag floorNameList = new ListTag();
        this.floorNames.forEach((height, name) -> {
            CompoundTag floorNameTag = new CompoundTag();
            floorNameTag.m_128405_("floorHeight", height.intValue());
            floorNameTag.m_128359_("floorName", name);
            floorNameList.add((Object)floorNameTag);
        });
        tag.m_128365_("floorNames", (Tag)floorNameList);
    }

    private void connectAsMultiblock() {
        this.multiElevators = null;
        if (this.isCoreElevator()) {
            this.multiElevators = new ArrayList<ElevatorBaseBlockEntity>();
            Stack<ElevatorBaseBlockEntity> todo = new Stack<ElevatorBaseBlockEntity>();
            todo.add(this);
            while (!todo.isEmpty()) {
                ElevatorBaseBlockEntity curElevator = (ElevatorBaseBlockEntity)todo.pop();
                if (!curElevator.isCoreElevator() || this.multiElevators.contains(curElevator)) continue;
                this.multiElevators.add(curElevator);
                curElevator.multiElevators = this.multiElevators;
                for (Direction face : DirectionUtil.HORIZONTALS) {
                    BlockEntity te = curElevator.getCachedNeighbor(face);
                    if (!(te instanceof ElevatorBaseBlockEntity) || te.m_58901_()) continue;
                    todo.push((ElevatorBaseBlockEntity)te);
                }
            }
            this.multiElevatorCount = this.multiElevators.size();
        }
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        super.onNeighborBlockUpdate(fromPos);
        this.getCoreElevator().updateRedstoneInputLevel();
        this.connectAsMultiblock();
        this.updateConnections();
    }

    private void updateConnections() {
        this.coreElevator = this.nonNullLevel().m_8055_(this.m_58899_().m_121945_(Direction.UP)).m_60734_() != ModBlocks.ELEVATOR_BASE.get() ? this : null;
    }

    public void moveUpgradesFromAbove() {
        BlockEntity brokenTE = this.nonNullLevel().m_7702_(this.m_58899_().m_121945_(Direction.UP));
        if (brokenTE instanceof ElevatorBaseBlockEntity) {
            this.camoState = ((ElevatorBaseBlockEntity)brokenTE).camoState;
            this.sendDescriptionPacket();
            for (int i = 0; i < this.getUpgradeHandler().getSlots(); ++i) {
                ItemStack stack = ((ElevatorBaseBlockEntity)brokenTE).getUpgradeHandler().getStackInSlot(i);
                ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)this.getUpgradeHandler(), (ItemStack)stack, (boolean)false);
                if (!excess.m_41619_()) {
                    PneumaticCraftUtils.dropItemOnGround(excess, this.f_58857_, this.m_58899_());
                }
                ((ElevatorBaseBlockEntity)brokenTE).getUpgradeHandler().setStackInSlot(i, ItemStack.f_41583_);
            }
        }
    }

    public void updateFloors(boolean notifyClient) {
        Level level = this.nonNullLevel();
        if (level.m_46467_() - this.lastFloorUpdate > 20L) {
            this.callerList.clear();
            this.floorList.clear();
            if (this.multiElevators != null) {
                int yOffset = 0;
                int worldHeight = level.m_6042_().f_63865_();
                BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
                block0: while (this.f_58858_.m_123342_() + yOffset < worldHeight - 2) {
                    boolean registeredThisFloor = false;
                    for (ElevatorBaseBlockEntity base : this.multiElevators) {
                        for (Direction dir : DirectionUtil.HORIZONTALS) {
                            mut.m_122190_((Vec3i)base.m_58899_());
                            mut.m_122184_(dir.m_122429_(), yOffset + 2, dir.m_122431_());
                            if (base.nonNullLevel().m_8055_((BlockPos)mut).m_60734_() != ModBlocks.ELEVATOR_CALLER.get()) continue;
                            this.callerList.add(mut.m_7949_());
                            if (!registeredThisFloor) {
                                this.floorList.add(yOffset);
                            }
                            registeredThisFloor = true;
                        }
                    }
                    ++yOffset;
                    for (ElevatorBaseBlockEntity base : this.multiElevators) {
                        if (base.nonNullLevel().m_8055_(base.m_58899_().m_6630_(yOffset)).m_60734_() == ModBlocks.ELEVATOR_FRAME.get()) continue;
                        break block0;
                    }
                }
                for (ElevatorBaseBlockEntity base : this.multiElevators) {
                    base.floorHeights = this.floorList.intStream().toArray();
                }
            }
            this.lastFloorUpdate = level.m_46467_();
        }
        ElevatorCallerBlockEntity.ElevatorButton[] elevatorButtons = this.layoutElevatorButtons();
        if (this.multiElevators != null) {
            for (ElevatorBaseBlockEntity base : this.multiElevators) {
                base.floorNames = new Int2ObjectOpenHashMap(this.floorNames);
            }
        }
        for (BlockPos p : this.callerList) {
            BlockEntity te = level.m_7702_(p);
            if (!(te instanceof ElevatorCallerBlockEntity)) continue;
            ElevatorCallerBlockEntity caller = (ElevatorCallerBlockEntity)te;
            int callerFloorHeight = p.m_123342_() - this.m_58899_().m_123342_() - 2;
            int callerFloor = -1;
            for (ElevatorCallerBlockEntity.ElevatorButton floor : elevatorButtons) {
                if (floor.floorHeight != callerFloorHeight) continue;
                callerFloor = floor.floorNumber;
                break;
            }
            if (callerFloor == -1) {
                Log.error("Error while updating elevator floors! This will cause a indexOutOfBoundsException, index = -1", new Object[0]);
            }
            caller.setEmittingRedstone(PneumaticCraftUtils.epsilonEquals(this.targetExtension, this.extension, 0.1) && PneumaticCraftUtils.epsilonEquals(this.extension, (double)callerFloorHeight, 0.1));
            caller.setFloors(elevatorButtons, callerFloor);
        }
        if (notifyClient && !level.f_46443_) {
            this.sendDescPacketFromAllElevators();
        }
    }

    private static int ceilDiv(int x, int y) {
        int q = x / y;
        return (x ^ y) >= 0 && q * y != x ? q + 1 : q;
    }

    private ElevatorCallerBlockEntity.ElevatorButton[] layoutElevatorButtons() {
        float startPosY;
        ElevatorCallerBlockEntity.ElevatorButton[] elevatorButtons = new ElevatorCallerBlockEntity.ElevatorButton[this.floorHeights.length];
        int columns = (elevatorButtons.length - 1) / 9 + 1;
        int buttonsPerCol = ElevatorBaseBlockEntity.ceilDiv(this.floorHeights.length, columns);
        float buttonWidth = (0.6f - 0.02f * (float)(columns - 1)) / (float)columns;
        float posX = 0.2f;
        float bh = (float)buttonsPerCol * 0.06f + (float)(buttonsPerCol - 1) * 0.02f;
        float posY = startPosY = 1.0f - (1.0f - bh) / 2.0f - 0.06f;
        int row = 0;
        for (int idx = 0; idx < elevatorButtons.length; ++idx) {
            int fh = this.floorHeights[idx];
            elevatorButtons[idx] = new ElevatorCallerBlockEntity.ElevatorButton(posX, posY, buttonWidth, 0.06f, idx, fh);
            elevatorButtons[idx].setColor((double)fh == this.targetExtension ? 0.0f : 1.0f, 1.0f, (double)fh == this.targetExtension ? 0.0f : 1.0f);
            String floorName = (String)this.floorNames.get(fh);
            if (floorName != null) {
                elevatorButtons[idx].buttonText = floorName;
            } else {
                this.floorNames.put(fh, (Object)elevatorButtons[idx].buttonText);
            }
            if (++row >= buttonsPerCol) {
                row = 0;
                posY = startPosY;
                posX += 0.02f + buttonWidth;
                continue;
            }
            posY -= 0.08f;
        }
        return elevatorButtons;
    }

    public void goToFloor(int floor) {
        if (this.getCoreElevator().isControlledByRedstone()) {
            this.getCoreElevator().getRedstoneController().setCurrentMode(1);
        }
        if (floor >= 0 && floor < this.floorHeights.length) {
            this.setTargetHeight(this.floorHeights[floor]);
        }
        this.updateFloors(false);
        this.sendDescPacketFromAllElevators();
    }

    private void setTargetHeight(float height) {
        height = Math.min(height, this.getMaxElevatorHeight());
        if (this.multiElevators != null) {
            for (ElevatorBaseBlockEntity base : this.multiElevators) {
                base.targetExtension = height;
            }
        }
    }

    public double getTargetExtension() {
        return this.targetExtension;
    }

    private void sendDescPacketFromAllElevators() {
        if (this.multiElevators != null) {
            for (ElevatorBaseBlockEntity base : this.multiElevators) {
                base.sendDescriptionPacket();
            }
        } else {
            this.sendDescriptionPacket();
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (double)(this.m_58899_().m_123341_() + 1), (double)(this.m_58899_().m_123342_() + 1) + this.extension, (double)(this.m_58899_().m_123343_() + 1));
    }

    private ElevatorBaseBlockEntity getCoreElevator() {
        if (this.coreElevator == null || this.nonNullLevel().f_46443_ && (this.nonNullLevel().m_46467_() & 0x3FL) == 0L) {
            this.coreElevator = ElevatorBaseBlock.getCoreTileEntity(this.nonNullLevel(), this.m_58899_());
        }
        return this.coreElevator;
    }

    public boolean isCoreElevator() {
        return this.getCoreElevator() == this;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != Direction.UP || this.nonNullLevel().m_8055_(this.f_58858_.m_121945_(side)).m_60734_() == ModBlocks.ELEVATOR_BASE.get();
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.setFloorName(textFieldID, text);
    }

    @Override
    public String getText(int textFieldID) {
        return this.getFloorName(textFieldID);
    }

    public String getFloorName(int floor) {
        return floor < this.floorHeights.length ? (String)this.floorNames.get(this.floorHeights[floor]) : "";
    }

    public void setFloorName(int floor, String name) {
        if (floor < this.floorHeights.length) {
            this.floorNames.put(this.floorHeights[floor], (Object)name);
            this.updateFloors(true);
        }
    }

    @Override
    public boolean isGuiUseableByPlayer(Player par1EntityPlayer) {
        return this.nonNullLevel().m_7702_(this.m_58899_()) == this;
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        super.addLuaMethods(registry);
        registry.registerLuaMethod(new LuaMethod("setHeight"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "height (in blocks)");
                ElevatorBaseBlockEntity.this.setTargetHeight(((Double)args[0]).floatValue());
                if (ElevatorBaseBlockEntity.this.getCoreElevator().isControlledByRedstone()) {
                    ElevatorBaseBlockEntity.this.getCoreElevator().getRedstoneController().setCurrentMode(1);
                }
                ElevatorBaseBlockEntity.this.getCoreElevator().sendDescPacketFromAllElevators();
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("getCurrentHeight"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{ElevatorBaseBlockEntity.this.getCoreElevator().extension};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getTargetHeight"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{ElevatorBaseBlockEntity.this.getCoreElevator().targetExtension};
            }
        });
        registry.registerLuaMethod(new LuaMethod("getVelocity"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{ElevatorBaseBlockEntity.this.getCoreElevator().extension - ElevatorBaseBlockEntity.this.getCoreElevator().oldExtension};
            }
        });
        registry.registerLuaMethod(new LuaMethod("setExternalControl"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "true/false");
                if (((Boolean)args[0]).booleanValue() && ElevatorBaseBlockEntity.this.getCoreElevator().isControlledByRedstone() || !((Boolean)args[0]).booleanValue() && !ElevatorBaseBlockEntity.this.getCoreElevator().isControlledByRedstone()) {
                    ElevatorBaseBlockEntity.this.getCoreElevator().getRedstoneController().setCurrentMode(1);
                }
                return null;
            }
        });
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public RedstoneController<ElevatorBaseBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public float getMinWorkingPressure() {
        return 3.0f;
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        CamouflageableBlockEntity.syncToClient(this);
    }

    @Override
    public MutableComponent getRedstoneTabTitle() {
        return PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.redstoneBehaviour.elevator.controlBy", new Object[0]);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ElevatorMenu(i, playerInventory, this.m_58899_());
    }
}

