/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.functions;

import java.io.File;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.LevelResource;

public class WorldFunctions {
    public static void setWorldTime(ServerLevel serverLevel, Integer time) {
        if (time < 0 || time > 24000) {
            return;
        }
        int days = WorldFunctions.getTotalDaysPassed(serverLevel);
        serverLevel.m_8615_((long)time.intValue() + (long)days * 24000L);
    }

    public static int getTotalTimePassed(ServerLevel serverLevel) {
        return (int)serverLevel.m_46468_();
    }

    public static int getTotalDaysPassed(ServerLevel serverLevel) {
        int currenttime = WorldFunctions.getTotalTimePassed(serverLevel);
        return (int)Math.floor((double)currenttime / 24000.0);
    }

    public static int getWorldTime(ServerLevel serverLevel) {
        return WorldFunctions.getTotalTimePassed(serverLevel) - WorldFunctions.getTotalDaysPassed(serverLevel) * 24000;
    }

    public static String getWorldDimensionName(Level level) {
        return level.m_46472_().m_135782_().toString();
    }

    public static boolean isOverworld(Level level) {
        return WorldFunctions.getWorldDimensionName(level).toLowerCase().endsWith("overworld");
    }

    public static boolean isNether(Level level) {
        return WorldFunctions.getWorldDimensionName(level).toLowerCase().endsWith("nether");
    }

    public static boolean isEnd(Level level) {
        return WorldFunctions.getWorldDimensionName(level).toLowerCase().endsWith("end");
    }

    public static Level getWorldIfInstanceOfAndNotRemote(LevelAccessor levelAccessor) {
        if (levelAccessor.m_5776_()) {
            return null;
        }
        if (levelAccessor instanceof Level) {
            return (Level)levelAccessor;
        }
        return null;
    }

    public static String getWorldPath(ServerLevel serverLevel) {
        return WorldFunctions.getWorldPath(serverLevel.m_7654_());
    }

    public static String getWorldPath(MinecraftServer minecraftServer) {
        String worldpath = minecraftServer.m_129843_(LevelResource.f_78182_).toString();
        return worldpath.substring(0, worldpath.length() - 2);
    }

    public static String getWorldFolderName(ServerLevel serverLevel) {
        return WorldFunctions.getWorldFolderName(serverLevel.m_7654_());
    }

    public static String getWorldFolderName(MinecraftServer minecraftServer) {
        String worldPath = WorldFunctions.getWorldPath(minecraftServer);
        return worldPath.substring(worldPath.lastIndexOf(File.separator) + 1);
    }
}

