/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.renderer.entity.FloatingItemEntityRenderer;
import com.sammy.malum.common.block.curiosities.spirit_crucible.CrucibleTuning;
import com.sammy.malum.common.block.curiosities.spirit_crucible.SpiritCrucibleCoreBlockEntity;
import com.sammy.malum.common.item.augment.AbstractAugmentItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.registry.common.item.ItemRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneBufferWrapper;

public class SpiritCrucibleRenderer
implements BlockEntityRenderer<SpiritCrucibleCoreBlockEntity> {
    private static float tuningForkHeldTimer = 0.0f;
    private static boolean isHoldingFork;
    private static final MultiBufferSource TEXT;

    public SpiritCrucibleRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static void checkForTuningFork(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            Item tuningFork = (Item)ItemRegistry.TUNING_FORK.get();
            if (player.m_21205_().m_41720_().equals(tuningFork) || player.m_21206_().m_41720_().equals(tuningFork)) {
                if (tuningForkHeldTimer < 20.0f) {
                    tuningForkHeldTimer += 1.0f;
                }
                isHoldingFork = true;
            } else if (tuningForkHeldTimer > 0.0f) {
                tuningForkHeldTimer -= 1.0f;
                isHoldingFork = false;
            }
        }
    }

    public void render(SpiritCrucibleCoreBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack stack;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        LodestoneBlockEntityInventory inventory = blockEntityIn.spiritInventory;
        int spiritsRendered = 0;
        if (!inventory.isEmpty()) {
            for (int i = 0; i < inventory.slotCount; ++i) {
                ItemStack item = inventory.getStackInSlot(i);
                Item item2 = item.m_41720_();
                if (!(item2 instanceof SpiritShardItem)) continue;
                SpiritShardItem shardItem = (SpiritShardItem)item2;
                poseStack.m_85836_();
                Vector3f offset = blockEntityIn.getSpiritItemOffset(spiritsRendered++, partialTicks).m_252839_();
                poseStack.m_252880_(offset.x(), offset.y(), offset.z());
                FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, shardItem.type, partialTicks);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(((float)(level.m_46467_() % 360L) + partialTicks) * 3.0f));
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                itemRenderer.m_269128_(item, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, poseStack, bufferIn, (Level)level, 0);
                poseStack.m_85849_();
            }
        }
        if (!(stack = blockEntityIn.inventory.getStackInSlot(0)).m_41619_()) {
            poseStack.m_85836_();
            Vec3 offset = blockEntityIn.getCentralItemOffset();
            poseStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(((float)(level.m_46467_() % 360L) + partialTicks) * 3.0f));
            poseStack.m_85841_(0.45f, 0.45f, 0.45f);
            itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, poseStack, bufferIn, (Level)level, 0);
            poseStack.m_85849_();
        }
        LodestoneBlockEntityInventory augmentInventory = blockEntityIn.augmentInventory;
        int augmentsRendered = 0;
        if (!augmentInventory.isEmpty()) {
            float total = augmentInventory.slotCount;
            float time = 240.0f;
            int i = 0;
            while ((float)i < total) {
                ItemStack item = augmentInventory.getStackInSlot(i);
                if (item.m_41720_() instanceof AbstractAugmentItem) {
                    double angle = (double)((float)augmentsRendered / total) * (Math.PI * 2);
                    poseStack.m_85836_();
                    Vector3f offset = blockEntityIn.getAugmentItemOffset(augmentsRendered++, partialTicks).m_252839_();
                    poseStack.m_252880_(offset.x(), offset.y(), offset.z());
                    poseStack.m_252781_(Axis.f_252436_.m_252961_((float)(angle -= (double)((float)((long)(blockEntityIn.spiritSpin + partialTicks)) % time / time) * (Math.PI * 2)) - (i % 2 == 0 ? 4.71f : 1.57f)));
                    poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                    itemRenderer.m_269128_(item, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, poseStack, bufferIn, (Level)level, 0);
                    poseStack.m_85849_();
                }
                ++i;
            }
        }
        if (tuningForkHeldTimer > 5.0f) {
            Font font = Minecraft.m_91087_().f_91062_;
            float timer = Mth.m_14036_((float)(tuningForkHeldTimer + (float)(isHoldingFork ? 1 : -1) * partialTicks), (float)0.0f, (float)20.0f);
            float scalar = Easing.SINE_IN_OUT.ease(timer / 20.0f, 0.0f, 1.0f, 1.0f);
            float scale = 0.016f - (1.0f - scalar) * 0.004f;
            Font.DisplayMode display = Font.DisplayMode.NORMAL;
            List<CrucibleTuning.CrucibleAttributeType> validValues = CrucibleTuning.CrucibleAttributeType.getValidValues(blockEntityIn.acceleratorData);
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 2.0f, 0.55f);
            poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            for (int i = 0; i < validValues.size(); ++i) {
                CrucibleTuning.CrucibleAttributeType tuningType = validValues.get(i);
                String dataPrint = tuningType.statDisplayFunction.apply(blockEntityIn.getAccelerationData());
                boolean important = tuningType.equals((Object)blockEntityIn.tuningType);
                MutableComponent dataText = Component.m_237113_((String)(" <" + dataPrint + ">"));
                MutableComponent text = Component.m_237115_((String)tuningType.translation());
                MutableComponent outlineText = Component.m_237115_((String)tuningType.translation());
                if (important) {
                    dataText.m_130940_(ChatFormatting.BOLD);
                    text = Component.m_237113_((String)"[").m_7220_((Component)text).m_7220_((Component)Component.m_237113_((String)"]")).m_130940_(ChatFormatting.BOLD);
                    outlineText = Component.m_237113_((String)"[").m_7220_((Component)outlineText).m_7220_((Component)Component.m_237113_((String)"]")).m_130940_(ChatFormatting.BOLD);
                }
                text.m_7220_((Component)dataText).m_130940_(ChatFormatting.AQUA);
                outlineText.m_7220_((Component)dataText).m_130940_(ChatFormatting.LIGHT_PURPLE);
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, (float)i * 0.15f, 0.0f);
                poseStack.m_85841_(scale, -scale, -scale);
                Matrix4f pose = poseStack.m_85850_().m_252922_();
                float f = (float)(-font.m_92852_((FormattedText)text)) / 2.0f;
                float xPos = 0.0f + f;
                int color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.38f * scalar));
                font.m_272077_((Component)text, xPos, 0.0f, color, false, pose, TEXT, display, 0, 0xF000F0);
                color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.18f * scalar));
                font.m_272077_((Component)text, xPos - 0.5f, 0.0f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.m_272077_((Component)text, xPos - 0.5f, 0.0f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.m_272077_((Component)text, xPos, 0.5f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.m_272077_((Component)text, xPos, -0.5f, color, false, pose, TEXT, display, 0, 0xF000F0);
                color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.12f * scalar));
                font.m_272077_((Component)text, xPos - 1.0f, 0.0f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.m_272077_((Component)outlineText, xPos + 1.0f, 0.0f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.m_272077_((Component)outlineText, xPos, 1.0f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.m_272077_((Component)text, xPos, -1.0f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.m_272077_((Component)outlineText, xPos - 0.5f, -0.5f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.m_272077_((Component)text, xPos - 0.5f, 0.5f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.m_272077_((Component)outlineText, xPos + 0.5f, 0.5f, color, false, pose, TEXT, display, 0, 0xF000F0);
                font.m_272077_((Component)text, xPos + 0.5f, -0.5f, color, false, pose, TEXT, display, 0, 0xF000F0);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
    }

    static {
        TEXT = new LodestoneBufferWrapper(LodestoneRenderTypeRegistry.ADDITIVE_TEXT, (MultiBufferSource)RenderHandler.DELAYED_RENDER.getTarget());
    }
}

