/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlockEntity;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class TotemPoleRenderer
implements BlockEntityRenderer<TotemPoleBlockEntity> {
    public TotemPoleRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TotemPoleBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Direction direction = (Direction)blockEntityIn.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        MalumSpiritType spiritType = blockEntityIn.type;
        if (spiritType == null) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LodestoneRenderType renderType = LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE.applyAndCache(RenderTypeToken.createCachedToken((ResourceLocation)spiritType.getTotemGlowTexture()));
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(direction.m_122435_()));
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        float pct = (float)blockEntityIn.chargeProgress / 20.0f;
        Color color = spiritType.getPrimaryColor();
        float alphaBonus = pct * 0.5f;
        float alpha = pct * 0.2f + alphaBonus;
        float ease = Easing.SINE_OUT.ease(pct, 0.0f, 1.0f, 1.0f);
        float distance = 0.2f - ease * 0.2f;
        float wobbleStrength = 0.1f - ease * 0.075f;
        Vector3f[] positions = new Vector3f[]{new Vector3f(-0.025f, -0.025f, 1.01f), new Vector3f(1.025f, -0.025f, 1.01f), new Vector3f(1.025f, 1.025f, 1.01f), new Vector3f(-0.025f, 1.025f, 1.01f)};
        float gameTime = (float)level.m_46467_() + partialTicks;
        int time = 160;
        for (int i = 0; i < 4; ++i) {
            TotemPoleRenderer.applyWobble(positions, wobbleStrength);
            double translation = 0.0;
            if (distance > 0.0f) {
                boolean odd = i % 2 == 0;
                double angle = (double)((float)i / 4.0f) * (Math.PI * 2);
                double offset = (double)distance * Math.cos(angle += (double)(gameTime % (float)time / (float)time) * (Math.PI * 2));
                translation = odd ? -offset : offset;
            }
            poseStack.m_85837_(translation, 0.0, 0.0);
            SpiritBasedWorldVFXBuilder.create(spiritType).setColor(color, alpha).setRenderType((RenderType)renderType).renderQuad(poseStack, positions, 1.0f);
            poseStack.m_85837_(-translation, 0.0, 0.0);
            alpha *= 1.0f - alphaBonus;
        }
        poseStack.m_85849_();
    }

    public static void applyWobble(Vector3f[] offsets, float strength) {
        float offset = 0.0f;
        for (Vector3f vector3f : offsets) {
            double time = (double)((float)Minecraft.m_91087_().f_91073_.m_46467_() / 40.0f) % Math.PI * 2.0;
            float sine = Mth.m_14031_((float)((float)(time + (double)offset * Math.PI * 2.0))) * strength;
            vector3f.add(sine, -sine, 0.0f);
            offset += 0.25f;
        }
    }
}

