/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.void_depot.VoidDepotBlockEntity;
import com.sammy.malum.registry.client.RenderTypeRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneBufferWrapper;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public class VoidDepotRenderer
implements BlockEntityRenderer<VoidDepotBlockEntity> {
    private static final RenderTypeToken VIGNETTE = RenderTypeToken.createToken((ResourceLocation)MalumMod.malumPath("textures/block/weeping_well/primordial_soup_vignette.png"));
    private static final RenderTypeToken NOISE_TEXTURE = RenderTypeToken.createToken((ResourceLocation)MalumMod.malumPath("textures/vfx/void_noise.png"));
    private static final MultiBufferSource ADDITIVE = new LodestoneBufferWrapper(LodestoneRenderTypeRegistry.ADDITIVE_TEXT, (MultiBufferSource)RenderHandler.LATE_DELAYED_RENDER.getTarget());
    private static final MultiBufferSource TRANSPARENT = new LodestoneBufferWrapper(LodestoneRenderTypeRegistry.TRANSPARENT_TEXT, (MultiBufferSource)RenderHandler.DELAYED_RENDER.getTarget());

    public VoidDepotRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(VoidDepotBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderQuad(blockEntityIn, poseStack, partialTicks);
    }

    public void renderQuad(VoidDepotBlockEntity voidDepot, PoseStack poseStack, float partialTicks) {
        float height = 0.9375f;
        float width = 0.3125f;
        Vector3f[] positions = new Vector3f[]{new Vector3f(-width, height, width), new Vector3f(width, height, width), new Vector3f(width, height, -width), new Vector3f(-width, height, -width)};
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld();
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.01f, 0.5f);
        builder.replaceBufferSource((MultiBufferSource)RenderHandler.LATE_DELAYED_RENDER.getTarget()).setRenderType((RenderType)LodestoneRenderTypeRegistry.TRANSPARENT_TEXTURE.applyAndCache(VIGNETTE)).renderQuad(poseStack, positions, 1.0f);
        long gameTime = voidDepot.m_58904_().m_46467_();
        float uOffset = ((float)gameTime + partialTicks) % 4000.0f / 2000.0f;
        float vOffset = ((float)gameTime + 500.0f + partialTicks) % 8000.0f / 8000.0f;
        float alpha = 0.05f;
        LodestoneRenderType renderType = RenderTypeRegistry.ADDITIVE_DISTORTED_TEXTURE.applyAndCache(NOISE_TEXTURE);
        builder.replaceBufferSource((MultiBufferSource)RenderHandler.DELAYED_RENDER.getTarget());
        for (int i = 0; i < 2; ++i) {
            builder.setAlpha(alpha);
            float speed = 1000.0f + 250.0f * (float)i;
            builder.setColor(SpiritTypeRegistry.WICKED_SPIRIT.getPrimaryColor()).setRenderType((RenderType)LodestoneRenderTypeRegistry.applyUniformChanges((LodestoneRenderType)LodestoneRenderTypeRegistry.copyAndStore((Object)i, (LodestoneRenderType)renderType), s -> {
                s.m_173356_("Speed").m_5985_(speed);
                s.m_173356_("Width").m_5985_(16.0f);
                s.m_173356_("Height").m_5985_(16.0f);
                s.m_173356_("UVEncasement").m_142558_(new Vector4f(-10.0f, 20.0f, -10.0f, 20.0f));
            }));
            builder.setUV(-uOffset, vOffset, 1.0f - uOffset, 1.0f + vOffset).renderQuad(poseStack, positions, 1.0f);
            builder.setUV(uOffset, -vOffset, 1.0f + uOffset, 1.0f - vOffset).renderQuad(poseStack, positions, 1.0f);
            alpha -= 0.0125f;
            uOffset = -uOffset - 0.2f;
            vOffset = -vOffset + 0.4f;
            poseStack.m_252880_(0.0f, 0.05f, 0.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            if (i != 0) continue;
            builder.setColor(SpiritTypeRegistry.ELDRITCH_SPIRIT.getPrimaryColor());
        }
        poseStack.m_85849_();
        if (voidDepot.textVisibility > 12.0f) {
            Font font = Minecraft.m_91087_().f_91062_;
            float timer = Mth.m_14036_((float)(voidDepot.textVisibility + (float)(voidDepot.nearTimer > 0 ? 1 : -1) * partialTicks), (float)0.0f, (float)40.0f);
            float scalar = Easing.SINE_IN_OUT.ease(timer / 40.0f, 0.0f, 1.0f, 1.0f);
            float scale = 0.016f - (1.0f - scalar) * 0.004f;
            Font.DisplayMode display = Font.DisplayMode.NORMAL;
            List<VoidDepotBlockEntity.VoidDepotGoal> goals = voidDepot.goals;
            List components = new ArrayList<MutableComponent>();
            if (!voidDepot.goals.isEmpty()) {
                components = goals.stream().map(g -> Component.m_237113_((String)(g.index + ": <" + g.deliveredAmount + "/" + g.amount + ">"))).collect(Collectors.toCollection(ArrayList::new));
            }
            components.addAll(voidDepot.textToDisplay.stream().map(Component::m_237113_).toList());
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 2.0f, 0.5f);
            poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            for (int i = 0; i < components.size(); ++i) {
                for (int j = 0; j < 2; ++j) {
                    MutableComponent text = ((MutableComponent)components.get(i)).m_6881_();
                    boolean isAdditive = j == 0;
                    MultiBufferSource bufferToUse = isAdditive ? ADDITIVE : TRANSPARENT;
                    MutableComponent outlineText = text.m_6881_();
                    text.m_130938_(isAdditive ? style -> style.m_131148_(TextColor.m_131266_((int)SpiritTypeRegistry.WICKED_SPIRIT.getPrimaryColor().getRGB())) : style -> style.m_131148_(TextColor.m_131266_((int)new Color(50, 0, 50).getRGB())));
                    outlineText.m_130940_(isAdditive ? ChatFormatting.RED : ChatFormatting.BLACK);
                    poseStack.m_85836_();
                    Matrix4f pose = poseStack.m_85850_().m_252922_();
                    poseStack.m_252880_(0.0f, (float)i * 0.15f, 0.0f);
                    if (isAdditive) {
                        poseStack.m_252880_(0.0f, 0.0f, 0.05f);
                    }
                    poseStack.m_85841_(scale, -scale, -scale);
                    float offset = isAdditive ? 0.4f : 0.8f;
                    float f = (float)(-font.m_92852_((FormattedText)text)) / 2.0f;
                    float xPos = 0.0f + f;
                    int color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((isAdditive ? 0.3f : 0.9f) * scalar));
                    font.m_272077_((Component)text, xPos, 0.0f, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((isAdditive ? 0.15f : 0.7f) * scalar));
                    font.m_272077_((Component)text, xPos - offset, 0.0f, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.m_272077_((Component)text, xPos - offset, 0.0f, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.m_272077_((Component)text, xPos, offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.m_272077_((Component)text, xPos, -offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    color = ColorHelper.getColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((isAdditive ? 0.1f : 0.5f) * scalar));
                    font.m_272077_((Component)text, xPos - 2.0f * offset, 0.0f, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.m_272077_((Component)outlineText, xPos + 2.0f * offset, 0.0f, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.m_272077_((Component)outlineText, xPos, 2.0f * offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.m_272077_((Component)text, xPos, -2.0f * offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.m_272077_((Component)outlineText, xPos - offset, -offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.m_272077_((Component)text, xPos - offset, offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.m_272077_((Component)outlineText, xPos + offset, offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    font.m_272077_((Component)text, xPos + offset, -offset, color, false, pose, bufferToUse, display, 0, 0xF000F0);
                    poseStack.m_85849_();
                }
            }
            poseStack.m_85849_();
        }
    }
}

