/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.client.SpiritBasedWorldVFXBuilder;
import com.sammy.malum.common.entity.FloatingItemEntity;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.EasingHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;

public class FloatingItemEntityRenderer
extends EntityRenderer<FloatingItemEntity> {
    public final ItemRenderer itemRenderer;

    public FloatingItemEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.m_174025_();
        this.f_114477_ = 0.0f;
        this.f_114478_ = 0.0f;
    }

    public void render(FloatingItemEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        MalumSpiritType spiritType = entity.getSpiritType();
        LodestoneRenderType renderType = LodestoneRenderTypeRegistry.ADDITIVE_ROUNDED_TEXTURE_TRIANGLE.applyAndCache(MalumRenderTypeTokens.CONCENTRATED_TRAIL);
        VFXBuilders.WorldVFXBuilder builder = SpiritBasedWorldVFXBuilder.create(spiritType).setRenderType((RenderType)renderType);
        RenderUtils.renderEntityTrail(poseStack, builder, entity.trail, (Entity)entity, spiritType.getPrimaryColor(), spiritType.getSecondaryColor(), 1.0f, partialTicks);
        FloatingItemEntityRenderer.renderSpiritEntity(entity, this.itemRenderer, partialTicks, poseStack, bufferIn, packedLightIn);
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public static void renderSpiritEntity(FloatingItemEntity entity, ItemRenderer itemRenderer, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        Level level = entity.m_9236_();
        ItemStack stack = entity.getItem();
        BakedModel model = itemRenderer.m_174264_(stack, level, null, entity.getItem().m_41613_());
        float yOffset = entity.getYOffset(partialTicks);
        float scale = model.m_7442_().m_269404_((ItemDisplayContext)ItemDisplayContext.GROUND).f_111757_.y();
        float rotation = entity.getRotation(partialTicks);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)yOffset, 0.0);
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, entity.getSpiritType(), partialTicks);
        poseStack.m_85837_(0.0, (double)(-0.25f * scale), 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252961_(rotation));
        itemRenderer.m_115143_(stack, ItemDisplayContext.GROUND, false, poseStack, bufferIn, packedLightIn, OverlayTexture.f_118083_, model);
        poseStack.m_85849_();
    }

    public static void renderSpiritGlimmer(PoseStack poseStack, MalumSpiritType spiritType, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, spiritType, 1.0f, partialTicks);
    }

    public static void renderSpiritGlimmer(PoseStack poseStack, MalumSpiritType spiritType, float scalar, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, SpiritBasedWorldVFXBuilder.create(spiritType), spiritType.getPrimaryColor(), spiritType.getSecondaryColor(), scalar, scalar, partialTicks);
    }

    public static void renderSpiritGlimmer(PoseStack poseStack, MalumSpiritType spiritType, float scaleScalar, float alphaScalar, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, SpiritBasedWorldVFXBuilder.create(spiritType), spiritType.getPrimaryColor(), spiritType.getSecondaryColor(), scaleScalar, alphaScalar, partialTicks);
    }

    public static void renderSpiritGlimmer(PoseStack poseStack, Color primaryColor, Color secondaryColor, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, primaryColor, secondaryColor, 1.0f, partialTicks);
    }

    public static void renderSpiritGlimmer(PoseStack poseStack, Color primaryColor, Color secondaryColor, float scalar, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, VFXBuilders.createWorld(), primaryColor, secondaryColor, scalar, scalar, partialTicks);
    }

    public static void renderSpiritGlimmer(PoseStack poseStack, Color primaryColor, Color secondaryColor, float scaleScalar, float alphaScalar, float partialTicks) {
        FloatingItemEntityRenderer.renderSpiritGlimmer(poseStack, VFXBuilders.createWorld(), primaryColor, secondaryColor, scaleScalar, alphaScalar, partialTicks);
    }

    public static void renderSpiritGlimmer(PoseStack poseStack, VFXBuilders.WorldVFXBuilder builder, Color primaryColor, Color secondaryColor, float scaleScalar, float alphaScalar, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        LodestoneRenderType star = LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE.applyAndCache(MalumRenderTypeTokens.STAR);
        LodestoneRenderType twinkle = LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE.applyAndCache(MalumRenderTypeTokens.TWINKLE);
        float gameTime = (float)level.m_46467_() + partialTicks;
        double sine = Math.abs(Math.sin(gameTime / 80.0f % 360.0f) * (double)0.075f);
        float bounce = EasingHelper.weightedEasingLerp((Easing)Easing.BOUNCE_IN_OUT, (float)(gameTime % 20.0f / 20.0f), (float)0.025f, (float)0.05f, (float)0.025f);
        float scale = (float)(((double)0.12f + sine + (double)bounce) * (double)scaleScalar);
        poseStack.m_85836_();
        poseStack.m_252781_(minecraft.m_91290_().m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        builder.setAlpha(0.6f * alphaScalar).setColor(primaryColor).setRenderType((RenderType)star).renderQuad(poseStack, scale * 0.8f);
        builder.setAlpha(0.8f * alphaScalar).setRenderType((RenderType)twinkle).renderQuad(poseStack, scale * 0.6f);
        builder.setAlpha(0.2f * alphaScalar).setColor(secondaryColor).renderQuad(poseStack, scale * 0.6f);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(FloatingItemEntity entity) {
        return TextureAtlas.f_118259_;
    }
}

