/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity.bolt;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;

public abstract class AbstractBoltEntityRenderer<T extends AbstractBoltProjectileEntity>
extends EntityRenderer<T> {
    public final Color primaryColor;
    public final Color secondaryColor;
    private static final RenderType TRAIL_TYPE = LodestoneRenderTypeRegistry.ADDITIVE_TEXTURE_TRIANGLE.apply(RenderTypeToken.createCachedToken((ResourceLocation)MalumMod.malumPath("textures/vfx/concentrated_trail.png")));

    public AbstractBoltEntityRenderer(EntityRendererProvider.Context context, Color primaryColor, Color secondaryColor) {
        super(context);
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.f_114477_ = 0.0f;
        this.f_114478_ = 0.0f;
    }

    public RenderType getTrailRenderType() {
        return TRAIL_TYPE;
    }

    public float getAlphaMultiplier() {
        return 1.0f;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        if (((AbstractBoltProjectileEntity)((Object)entity)).spawnDelay > 0) {
            return;
        }
        float effectScalar = ((AbstractBoltProjectileEntity)((Object)entity)).getVisualEffectScalar();
        float alphaScalar = Mth.m_14036_((float)(effectScalar * this.getAlphaMultiplier()), (float)0.0f, (float)1.0f);
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setRenderType(this.getTrailRenderType());
        RenderUtils.renderEntityTrail(poseStack, builder, ((AbstractBoltProjectileEntity)((Object)entity)).trailPointBuilder, entity, this.primaryColor, this.secondaryColor, effectScalar, alphaScalar, partialTicks);
        RenderUtils.renderEntityTrail(poseStack, builder, ((AbstractBoltProjectileEntity)((Object)entity)).spinningTrailPointBuilder, entity, this.primaryColor, this.secondaryColor, effectScalar, alphaScalar, partialTicks);
        super.m_7392_(entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TextureAtlas.f_118259_;
    }
}

