/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.objects.progression;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.BookWidgetStyle;
import com.sammy.malum.client.screen.codex.objects.BookObject;
import com.sammy.malum.client.screen.codex.screens.AbstractProgressionCodexScreen;
import com.sammy.malum.client.screen.codex.screens.EntryScreen;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ProgressionEntryObject
extends BookObject<AbstractProgressionCodexScreen> {
    public final BookEntry entry;
    public BookWidgetStyle style = BookWidgetStyle.RUNEWOOD;
    public Predicate<AbstractProgressionCodexScreen> isValid = t -> true;
    public ItemStack iconStack;

    public ProgressionEntryObject(BookEntry entry, int posX, int posY) {
        super(posX, posY, 32, 32);
        this.entry = entry;
    }

    @Override
    public boolean isValid(AbstractProgressionCodexScreen screen) {
        return this.isValid.test(screen) && this.entry.shouldShow();
    }

    @Override
    public void click(AbstractProgressionCodexScreen screen, double mouseX, double mouseY) {
        if (this.entry.hasContents()) {
            EntryScreen.openScreen(screen, this);
        }
    }

    @Override
    public void render(AbstractProgressionCodexScreen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = guiGraphics.m_280168_();
        int posX = this.getOffsetXPosition() - (this.style.textureWidth() - 32) / 2;
        int posY = this.getOffsetYPosition() - (this.style.textureHeight() - 32) / 2;
        ArcanaCodexHelper.renderTexture(WIDGET_FADE_TEXTURE, poseStack, posX - 13, posY - 13, 0.0f, 0.0f, 58, 58);
        ArcanaCodexHelper.renderTexture(this.style.frameTexture(), poseStack, posX, posY, 0.0f, 0.0f, this.style.textureWidth(), this.style.textureHeight());
        ArcanaCodexHelper.renderTexture(this.style.fillingTexture(), poseStack, posX, posY, 0.0f, 0.0f, this.style.textureWidth(), this.style.textureHeight());
        if (this.iconStack != null) {
            guiGraphics.m_280480_(this.iconStack, posX + 8, posY + 8);
        }
    }

    @Override
    public void renderLate(AbstractProgressionCodexScreen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isHoveredOver && this.entry.hasTooltip()) {
            List<Component> list = Arrays.asList(ArcanaCodexHelper.convertToComponent(this.entry.translationKey(), this.entry.titleStyle), ArcanaCodexHelper.convertToComponent(this.entry.descriptionTranslationKey(), this.entry.subtitleStyle));
            guiGraphics.m_280666_(Minecraft.m_91087_().f_91062_, list, mouseX, mouseY);
        }
    }

    public ProgressionEntryObject setIcon(Supplier<? extends Item> item) {
        return this.setIcon(item.get());
    }

    public ProgressionEntryObject setIcon(Item item) {
        this.iconStack = item.m_7968_();
        return this;
    }

    public ProgressionEntryObject setIcon(ItemStack itemStack) {
        this.iconStack = itemStack;
        return this;
    }

    public ProgressionEntryObject setStyle(BookWidgetStyle style) {
        this.style = style;
        return this;
    }

    public ProgressionEntryObject setValidityChecker(Predicate<AbstractProgressionCodexScreen> isValid) {
        this.isValid = isValid;
        return this;
    }
}

