/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages.recipe;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumScreen;
import com.sammy.malum.client.screen.codex.screens.EntryScreen;
import com.sammy.malum.common.recipe.SpiritRepairRecipe;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.systems.recipe.IRecipeComponent;

public class SpiritRepairPage
extends BookPage {
    private final SpiritRepairRecipe recipe;

    public SpiritRepairPage(Predicate<SpiritRepairRecipe> predicate) {
        super(MalumMod.malumPath("textures/gui/book/pages/spirit_repair_page.png"));
        if (Minecraft.m_91087_() == null) {
            this.recipe = null;
            return;
        }
        this.recipe = SpiritRepairRecipe.getRecipe((Level)Minecraft.m_91087_().f_91073_, predicate);
    }

    public SpiritRepairPage(SpiritRepairRecipe recipe) {
        super(MalumMod.malumPath("textures/gui/book/pages/spirit_repair_page.png"));
        this.recipe = recipe;
    }

    @Override
    public boolean isValid() {
        return this.recipe != null;
    }

    public static SpiritRepairPage fromInput(Item inputItem) {
        return new SpiritRepairPage(s -> s.doesInputMatch(inputItem.m_7968_()));
    }

    @Override
    public void render(EntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        ArcanaCodexHelper.renderComponents(screen, guiGraphics, this.recipe.spirits, left + 63, top + 16, mouseX, mouseY, false);
        List<ItemStack> damaged = this.recipe.inputs.stream().map(Item::m_7968_).peek(s -> s.m_41721_(Mth.m_14143_((float)((float)s.m_41776_() * this.recipe.durabilityPercentage)))).collect(Collectors.toList());
        List<ItemStack> repaired = this.recipe.inputs.stream().map(s -> SpiritRepairRecipe.getRepairRecipeOutput(s.m_7968_())).collect(Collectors.toList());
        ArcanaCodexHelper.renderItem((AbstractMalumScreen)screen, guiGraphics, damaged, left + 82, top + 59, mouseX, mouseY);
        ArcanaCodexHelper.renderComponent(screen, guiGraphics, (IRecipeComponent)this.recipe.repairMaterial, left + 44, top + 59, mouseX, mouseY);
        ArcanaCodexHelper.renderItem((AbstractMalumScreen)screen, guiGraphics, repaired, left + 63, top + 126, mouseX, mouseY);
    }
}

