/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages.recipe;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumScreen;
import com.sammy.malum.client.screen.codex.screens.EntryScreen;
import com.sammy.malum.common.recipe.SpiritTransmutationRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class SpiritTransmutationRecipePage
extends BookPage {
    private final String headlineTranslationKey;
    private final List<SpiritTransmutationRecipe> recipes;

    public SpiritTransmutationRecipePage(String headlineTranslationKey, Predicate<SpiritTransmutationRecipe> predicate) {
        super(MalumMod.malumPath("textures/gui/book/pages/transmutation_recipe_page.png"));
        this.headlineTranslationKey = headlineTranslationKey;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            this.recipes = new ArrayList<SpiritTransmutationRecipe>();
            SpiritTransmutationRecipe recipe = SpiritTransmutationRecipe.getRecipe((Level)level, predicate);
            if (recipe != null) {
                this.recipes.add(recipe);
                if (recipe.group != null) {
                    for (SpiritTransmutationRecipe otherRecipe : SpiritTransmutationRecipe.getRecipes((Level)level)) {
                        if (((Object)((Object)recipe)).equals((Object)otherRecipe) || !recipe.group.equals(otherRecipe.group)) continue;
                        this.recipes.add(otherRecipe);
                    }
                }
            }
        } else {
            this.recipes = null;
        }
    }

    public SpiritTransmutationRecipePage(String headlineTranslationKey, SpiritTransmutationRecipe recipe) {
        super(MalumMod.malumPath("textures/gui/book/pages/transmutation_recipe_page.png"));
        this.headlineTranslationKey = headlineTranslationKey;
        this.recipes = new ArrayList<SpiritTransmutationRecipe>(List.of(recipe));
    }

    public String headlineTranslationKey() {
        return "malum.gui.book.entry.page.headline." + this.headlineTranslationKey;
    }

    public static SpiritTransmutationRecipePage fromInput(String headlineTranslationKey, Item inputItem) {
        return new SpiritTransmutationRecipePage(headlineTranslationKey, s -> s.doesInputMatch(inputItem.m_7968_()));
    }

    public static SpiritTransmutationRecipePage fromOutput(String headlineTranslationKey, Item outputItem) {
        return new SpiritTransmutationRecipePage(headlineTranslationKey, s -> s.doesOutputMatch(outputItem.m_7968_()));
    }

    @Override
    public boolean isValid() {
        return this.recipes != null;
    }

    @Override
    public void render(EntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        MutableComponent component = Component.m_237115_((String)this.headlineTranslationKey());
        ArcanaCodexHelper.renderText(guiGraphics, (Component)component, left + 70 - Minecraft.m_91087_().f_91062_.m_92895_(component.getString()) / 2, top + 5);
        SpiritTransmutationRecipe recipe = this.recipes.get(this.getIndex());
        ArcanaCodexHelper.renderItem((AbstractMalumScreen)screen, guiGraphics, recipe.ingredient, left + 63, top + 59, mouseX, mouseY);
        ArcanaCodexHelper.renderItem((AbstractMalumScreen)screen, guiGraphics, recipe.output, left + 63, top + 126, mouseX, mouseY);
    }

    public int getIndex() {
        return (int)(Minecraft.m_91087_().f_91073_.m_46467_() % (20L * (long)this.recipes.size()) / 20L);
    }
}

