/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages.text;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumScreen;
import com.sammy.malum.client.screen.codex.screens.EntryScreen;
import com.sammy.malum.registry.client.ScreenParticleRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.lodestar.lodestone.handlers.screenparticle.ScreenParticleHandler;
import team.lodestar.lodestone.registry.common.particle.LodestoneScreenParticleRegistry;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneScreenParticleRenderType;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;

public class WeepingWellTextPage
extends BookPage {
    private static final ScreenParticleHolder ITEM_PARTICLES = new ScreenParticleHolder();
    private final String headlineTranslationKey;
    private final String translationKey;
    private final ItemStack stack;

    public WeepingWellTextPage(String headlineTranslationKey, String translationKey, ItemStack stack) {
        super(MalumMod.malumPath("textures/gui/book/pages/weeping_well_page.png"));
        this.headlineTranslationKey = headlineTranslationKey;
        this.translationKey = translationKey;
        this.stack = stack;
    }

    public WeepingWellTextPage(String headlineTranslationKey, String translationKey, Item spirit) {
        this(headlineTranslationKey, translationKey, spirit.m_7968_());
    }

    public String headlineTranslationKey() {
        return "malum.gui.book.entry.page.headline." + this.headlineTranslationKey;
    }

    public String translationKey() {
        return "malum.gui.book.entry.page.text." + this.translationKey;
    }

    @Override
    public void render(EntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        RandomSource rand = level.f_46441_;
        MutableComponent component = Component.m_237115_((String)this.headlineTranslationKey());
        ArcanaCodexHelper.renderText(guiGraphics, (Component)component, left + 70 - Minecraft.m_91087_().f_91062_.m_92895_(component.getString()) / 2, top + 5);
        ArcanaCodexHelper.renderWrappingText(guiGraphics, this.translationKey(), left + 6, top + 75, 130);
        if (!isRepeat) {
            if (ScreenParticleHandler.canSpawnParticles) {
                ITEM_PARTICLES.tick();
            }
            ScreenParticleHandler.renderParticles((ScreenParticleHolder)ITEM_PARTICLES);
        }
        ArcanaCodexHelper.renderItem((AbstractMalumScreen)screen, guiGraphics, this.stack, left + 63, top + 38, mouseX, mouseY);
        if (level.m_46467_() % 4L == 0L && ScreenParticleHandler.canSpawnParticles) {
            int lifetime = 100;
            float scale = 1.85f;
            float spin = 6.28f * ((float)level.m_46467_() / 240.0f);
            int x = left + 71;
            int y = top + 46;
            ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.STAR, (ScreenParticleHolder)ITEM_PARTICLES).setTransparencyData(GenericParticleData.create((float)0.02f, (float)0.4f, (float)0.0f).build()).setSpinData(SpinParticleData.create((float)0.0f).setSpinOffset(spin).build()).setScaleData(GenericParticleData.create((float)0.0f, (float)(scale * 1.2f)).build()).setColorData(SpiritTypeRegistry.WICKED_SPIRIT.createColorData().setCoefficient(0.4f).build()).setLifetime(lifetime).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).spawn((double)x, (double)y);
            ScreenParticleBuilder.create(ScreenParticleRegistry.SAW, (ScreenParticleHolder)ITEM_PARTICLES).setTransparencyData(GenericParticleData.create((float)0.02f, (float)0.2f, (float)0.0f).build()).setSpinData(SpinParticleData.create((float)0.0f).setSpinOffset(spin).build()).setScaleData(GenericParticleData.create((float)0.0f, (float)(scale * 0.9f)).build()).setColorData(SpiritTypeRegistry.WICKED_SPIRIT.createColorData().setCoefficient(0.4f).build()).setLifetime(lifetime).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).spawn((double)x, (double)y);
        }
    }
}

