/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.PlacedBookEntry;
import com.sammy.malum.client.screen.codex.PlacedBookEntryBuilder;
import com.sammy.malum.client.screen.codex.handlers.EntryObjectHandler;
import com.sammy.malum.client.screen.codex.objects.BookObject;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumScreen;
import com.sammy.malum.registry.common.SoundRegistry;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import org.lwjgl.opengl.GL11;

public abstract class AbstractProgressionCodexScreen
extends AbstractMalumScreen {
    public static final ResourceLocation FRAME_TEXTURE = MalumMod.malumPath("textures/gui/book/frame.png");
    public static final ResourceLocation FRAME_FADE_TEXTURE = MalumMod.malumPath("textures/gui/book/frame_fade.png");
    public float xOffset;
    public float yOffset;
    public float cachedXOffset;
    public float cachedYOffset;
    public boolean ignoreNextMouseInput;
    public int transitionTimer;
    public int timesTransitioned;
    public boolean isVoidTouched;
    public final EntryObjectHandler bookObjectHandler = new EntryObjectHandler();
    public final int bookWidth;
    public final int bookHeight;
    public final int bookInsideWidth;
    public final int bookInsideHeight;
    public final int backgroundImageWidth;
    public final int backgroundImageHeight;

    protected AbstractProgressionCodexScreen(Supplier<SoundEvent> sweetenerSound, int backgroundImageWidth, int backgroundImageHeight) {
        this(sweetenerSound, 378, 250, 344, 218, backgroundImageWidth, backgroundImageHeight);
    }

    protected AbstractProgressionCodexScreen(Supplier<SoundEvent> sweetenerSound, int bookWidth, int bookHeight, int bookInsideWidth, int bookInsideHeight, int backgroundImageWidth, int backgroundImageHeight) {
        super((Component)Component.m_237119_(), sweetenerSound);
        this.bookWidth = bookWidth;
        this.bookHeight = bookHeight;
        this.bookInsideWidth = bookInsideWidth;
        this.bookInsideHeight = bookInsideHeight;
        this.backgroundImageWidth = backgroundImageWidth;
        this.backgroundImageHeight = backgroundImageHeight;
        this.f_96541_ = Minecraft.m_91087_();
    }

    public abstract void renderBackground(PoseStack var1);

    public abstract Collection<PlacedBookEntry> getEntries();

    public void addEntry(String identifier, int xOffset, int yOffset) {
        this.addEntry(identifier, xOffset, yOffset, b -> {});
    }

    public void addEntry(String identifier, int xOffset, int yOffset, Consumer<PlacedBookEntryBuilder> consumer) {
        PlacedBookEntryBuilder builder = PlacedBookEntry.build(identifier, xOffset, yOffset);
        consumer.accept(builder);
        if (builder.hasFragment()) {
            this.getEntries().add(builder.buildFragment());
        }
        this.getEntries().add(builder.build());
    }

    public PlacedBookEntry getEntry(String identifier) {
        return this.getEntries().stream().filter(p -> p.identifier.matches(identifier)).findFirst().orElseThrow(() -> new NullPointerException("Encyclopedia Arcana tried initiating a reference to the " + identifier + " entry, which doesn't exist"));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        int guiLeft = this.getGuiLeft();
        int guiTop = this.getGuiTop();
        PoseStack poseStack = guiGraphics.m_280168_();
        this.renderBackground(poseStack);
        GL11.glEnable((int)3089);
        this.cut();
        this.bookObjectHandler.renderObjects(this, guiGraphics, (float)guiLeft + this.xOffset, (float)guiTop + this.yOffset, mouseX, mouseY, partialTicks);
        GL11.glDisable((int)3089);
        ArcanaCodexHelper.renderTexture(FRAME_FADE_TEXTURE, poseStack, guiLeft, guiTop, 0.0f, 0.0f, this.bookWidth, this.bookHeight);
        if (this.transitionTimer > 0) {
            ArcanaCodexHelper.renderTransitionFade(this, poseStack);
        }
        ArcanaCodexHelper.renderTexture(FRAME_TEXTURE, poseStack, guiLeft, guiTop, 400, 0.0f, 0.0f, this.bookWidth, this.bookHeight);
        this.bookObjectHandler.renderObjectsLate(this, guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.ignoreNextMouseInput) {
            this.ignoreNextMouseInput = false;
            return super.m_6348_(mouseX, mouseY, button);
        }
        if (this.xOffset != this.cachedXOffset || this.yOffset != this.cachedYOffset) {
            return super.m_6348_(mouseX, mouseY, button);
        }
        this.bookObjectHandler.click(this, mouseX, mouseY);
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.xOffset = (float)((double)this.xOffset + dragX);
        this.yOffset = (float)((double)this.yOffset + dragY);
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.cachedXOffset = this.xOffset;
        this.cachedYOffset = this.yOffset;
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_7379_() {
        super.m_7379_();
        this.playSweetenedSound((Supplier<SoundEvent>)SoundRegistry.ARCANA_CODEX_CLOSE, 0.75f);
    }

    public void m_86600_() {
        if (this.transitionTimer > 0) {
            --this.transitionTimer;
        }
        super.m_86600_();
    }

    @Override
    public boolean isHovering(double mouseX, double mouseY, float posX, float posY, int width, int height) {
        if (!this.isInView(mouseX, mouseY)) {
            return false;
        }
        return super.isHovering(mouseX, mouseY, posX, posY, width, height);
    }

    public void setupObjects() {
        this.f_96543_ = this.f_96541_.m_91268_().m_85445_();
        this.f_96544_ = this.f_96541_.m_91268_().m_85446_();
        this.bookObjectHandler.setupEntryObjects(this);
    }

    public void faceObject(BookObject<?> object) {
        this.f_96543_ = this.f_96541_.m_91268_().m_85445_();
        this.f_96544_ = this.f_96541_.m_91268_().m_85446_();
        this.xOffset = (float)(-object.posX) + (float)this.bookInsideWidth / 2.0f;
        this.yOffset = (float)(-object.posY) + (float)this.bookInsideHeight / 2.0f;
    }

    @Override
    public void openScreen(boolean silentMouseInput) {
        Minecraft.m_91087_().m_91152_((Screen)this);
        this.ignoreNextMouseInput = silentMouseInput;
    }

    public void renderBackground(PoseStack poseStack, ResourceLocation texture, float xModifier, float yModifier) {
        int insideLeft = this.getInsideLeft();
        int insideTop = this.getInsideTop();
        float uOffset = (float)this.bookInsideWidth / 8.0f - this.xOffset * xModifier;
        float vOffset = (float)(this.backgroundImageHeight - this.bookInsideHeight) - this.yOffset * yModifier;
        if (uOffset <= 0.0f) {
            uOffset = 0.0f;
        }
        if (uOffset > (float)this.bookInsideWidth / 2.0f) {
            uOffset = (float)this.bookInsideWidth / 2.0f;
        }
        if (vOffset <= (float)this.backgroundImageHeight / 2.0f) {
            vOffset = (float)this.backgroundImageHeight / 2.0f;
        }
        if (vOffset > (float)(this.backgroundImageHeight - this.bookInsideHeight)) {
            vOffset = this.backgroundImageHeight - this.bookInsideHeight;
        }
        ArcanaCodexHelper.renderTexture(texture, poseStack, insideLeft, insideTop, uOffset, vOffset, this.bookInsideWidth, this.bookInsideHeight, this.backgroundImageWidth / 2, this.backgroundImageHeight / 2);
    }

    public boolean isInView(double mouseX, double mouseY) {
        return mouseX >= (double)this.getInsideLeft() && mouseY >= (double)this.getInsideTop() && mouseX <= (double)(this.getInsideLeft() + this.bookInsideWidth) && mouseY <= (double)(this.getInsideTop() + this.bookInsideHeight);
    }

    public void cut() {
        int scale = (int)this.getMinecraft().m_91268_().m_85449_();
        GL11.glScissor((int)(this.getInsideLeft() * scale), (int)(this.getMinecraft().m_91268_().m_85442_() - (this.getInsideTop() + this.bookInsideHeight) * scale), (int)(this.bookInsideWidth * scale), (int)(this.bookInsideHeight * scale));
    }

    public int getInsideLeft() {
        return this.getGuiLeft() + 17;
    }

    public int getInsideTop() {
        return this.getGuiTop() + 14;
    }

    public int getGuiLeft() {
        return (this.f_96543_ - this.bookWidth) / 2;
    }

    public int getGuiTop() {
        return (this.f_96544_ - this.bookHeight) / 2;
    }

    public int getTransitionDuration() {
        return 80 - Mth.m_14045_((int)(this.timesTransitioned - 2), (int)0, (int)4) * 10;
    }
}

