/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.obelisk.runewood;

import com.sammy.malum.common.block.curiosities.obelisk.ObeliskCoreBlockEntity;
import com.sammy.malum.common.block.curiosities.spirit_altar.IAltarAccelerator;
import com.sammy.malum.common.block.curiosities.spirit_altar.SpiritAltarBlockEntity;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.registry.common.block.BlockRegistry;
import com.sammy.malum.visual_effects.SpiritAltarParticleEffects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.systems.multiblock.MultiBlockStructure;

public class RunewoodObeliskBlockEntity
extends ObeliskCoreBlockEntity
implements IAltarAccelerator {
    private static final Vec3 OBELISK_PARTICLE_OFFSET = new Vec3(0.5, 2.0, 0.5);
    public static final IAltarAccelerator.AltarAcceleratorType OBELISK = new IAltarAccelerator.AltarAcceleratorType(4, "obelisk");
    public static final Supplier<MultiBlockStructure> STRUCTURE = () -> MultiBlockStructure.of((MultiBlockStructure.StructurePiece[])new MultiBlockStructure.StructurePiece[]{new MultiBlockStructure.StructurePiece(0, 1, 0, ((Block)BlockRegistry.RUNEWOOD_OBELISK_COMPONENT.get()).m_49966_())});

    public RunewoodObeliskBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ObeliskCoreBlockEntity>)((BlockEntityType)BlockEntityRegistry.RUNEWOOD_OBELISK.get()), STRUCTURE.get(), pos, state);
    }

    @Override
    public IAltarAccelerator.AltarAcceleratorType getAcceleratorType() {
        return OBELISK;
    }

    @Override
    public float getAcceleration() {
        return 0.25f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addParticles(SpiritAltarBlockEntity blockEntity, MalumSpiritType activeSpiritType) {
        SpiritAltarParticleEffects.runewoodObeliskParticles(this, blockEntity, activeSpiritType);
    }

    public Vec3 getParticleOffset() {
        return OBELISK_PARTICLE_OFFSET;
    }
}

