/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.void_depot;

import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.WeepingWellParticleEffects;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;

public class VoidDepotBlockEntity
extends LodestoneBlockEntity {
    public final List<VoidDepotGoal> goals = new ArrayList<VoidDepotGoal>();
    public final List<String> textToDisplay = new ArrayList<String>();
    public boolean repeatable = false;
    public boolean oncePerPlayer = true;
    public List<UUID> playersWhoCompleted = new ArrayList<UUID>();
    public int nearTimer;
    public float textVisibility = 0.0f;
    public static final StringRepresentable.EnumCodec<VoidDepotGoal.VoidDepotGoalType> CODEC = StringRepresentable.m_216439_(VoidDepotGoal.VoidDepotGoalType::values);

    public VoidDepotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.VOID_DEPOT.get(), pos, state);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        CompoundTag textTag = new CompoundTag();
        if (!this.textToDisplay.isEmpty()) {
            for (int i = 0; i < this.textToDisplay.size(); ++i) {
                String text = this.textToDisplay.get(i);
                textTag.m_128359_("line_" + i, text);
            }
        }
        compound.m_128365_("textDisplay", (Tag)textTag);
        CompoundTag goalsTag = new CompoundTag();
        if (!this.goals.isEmpty()) {
            int goalsSize = this.goals.size();
            for (int i = 0; i < goalsSize; ++i) {
                VoidDepotGoal goal = this.goals.get(i);
                CompoundTag goalTag = goal.serialize();
                goalTag.m_128359_("goalName", goal.index);
                goalTag.m_128359_("type", goal.type.name);
                goalTag.m_128379_("completed", goal.completed);
                goalsTag.m_128365_("goal_" + i, (Tag)goalTag);
            }
            goalsTag.m_128379_("repeatable", this.repeatable);
            goalsTag.m_128379_("oncePerPlayer", this.oncePerPlayer);
            if (!this.playersWhoCompleted.isEmpty()) {
                CompoundTag playerList = new CompoundTag();
                for (int i = 0; i < this.playersWhoCompleted.size(); ++i) {
                    playerList.m_128362_("player_" + i, this.playersWhoCompleted.get(i));
                }
                goalsTag.m_128365_("playersWhoCompleted", (Tag)playerList);
            }
            compound.m_128365_("goals", (Tag)goalsTag);
        }
    }

    public void m_142466_(CompoundTag compound) {
        int i;
        super.m_142466_(compound);
        if (compound.m_128441_("textDisplay")) {
            this.textToDisplay.clear();
            CompoundTag textTag = compound.m_128469_("textDisplay");
            int lineCount = textTag.m_128440_();
            for (i = 0; i < lineCount; ++i) {
                if (!textTag.m_128441_("line_" + i)) continue;
                this.textToDisplay.add(textTag.m_128461_("line_" + i));
            }
        }
        if (compound.m_128441_("goals")) {
            this.goals.clear();
            CompoundTag goalsTag = compound.m_128469_("goals");
            int goalCount = goalsTag.m_128440_();
            for (i = 0; i < goalCount; ++i) {
                CompoundTag goalTag;
                VoidDepotGoal.VoidDepotGoalType type;
                if (!goalsTag.m_128441_("goal_" + i) || (type = (VoidDepotGoal.VoidDepotGoalType)CODEC.m_216455_((goalTag = goalsTag.m_128469_("goal_" + i)).m_128461_("type"))) == null) continue;
                VoidDepotGoal goal = type.deserializer.apply(goalTag);
                goal.setCompleted(goalTag.m_128471_("completed"));
                this.goals.add(goal);
            }
            this.playersWhoCompleted.clear();
            CompoundTag playerList = goalsTag.m_128469_("playersWhoCompleted");
            if (!playerList.m_128456_()) {
                int playerCount = playerList.m_128440_();
                for (int i2 = 0; i2 < playerCount; ++i2) {
                    if (!playerList.m_128441_("player_" + i2)) continue;
                    this.playersWhoCompleted.add(playerList.m_128342_("player_" + i2));
                }
            }
            this.repeatable = goalsTag.m_128471_("repeatable");
            this.oncePerPlayer = goalsTag.m_128471_("oncePerPlayer");
        }
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        if (!this.goals.isEmpty()) {
            if (player.m_21120_(hand).m_41720_().equals(ItemRegistry.CREATIVE_SCYTHE.get())) {
                ArrayList<VoidDepotGoal> newGoals = new ArrayList<VoidDepotGoal>();
                for (VoidDepotGoal goal : this.goals) {
                    int amount;
                    if (goal instanceof ItemGoal) {
                        ItemGoal itemGoal = (ItemGoal)goal;
                        amount = Math.max(itemGoal.amount / 2, 1);
                        newGoals.add(new ItemGoal(itemGoal.index, itemGoal.item, amount, Math.min(itemGoal.deliveredAmount, amount)));
                    }
                    if (!(goal instanceof ExperienceGoal)) continue;
                    ExperienceGoal experienceGoal = (ExperienceGoal)goal;
                    amount = Math.max(experienceGoal.amount / 2, 1);
                    newGoals.add(new ExperienceGoal(experienceGoal.index, amount, Math.min(experienceGoal.deliveredAmount, amount)));
                }
                this.goals.clear();
                this.goals.addAll(newGoals);
                BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.m_58899_());
                return InteractionResult.SUCCESS;
            }
            if (player.m_21120_(hand).m_41720_().equals(ItemRegistry.VOID_CONDUIT.get())) {
                ArrayList<VoidDepotGoal> newGoals = new ArrayList<VoidDepotGoal>();
                for (VoidDepotGoal goal : this.goals) {
                    if (goal instanceof ItemGoal) {
                        ItemGoal itemGoal = (ItemGoal)goal;
                        newGoals.add(new ItemGoal(itemGoal.index, itemGoal.item, itemGoal.amount * 2, itemGoal.deliveredAmount));
                    }
                    if (!(goal instanceof ExperienceGoal)) continue;
                    ExperienceGoal experienceGoal = (ExperienceGoal)goal;
                    newGoals.add(new ExperienceGoal(experienceGoal.index, experienceGoal.amount * 2, experienceGoal.deliveredAmount));
                }
                this.goals.clear();
                this.goals.addAll(newGoals);
                BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.m_58899_());
                return InteractionResult.SUCCESS;
            }
            if (this.oncePerPlayer && this.playersWhoCompleted.contains(player.m_20148_())) {
                return InteractionResult.PASS;
            }
            boolean isSuccessful = false;
            for (VoidDepotGoal goal : this.goals) {
                int givenQuantity;
                if (goal.isCompleted()) continue;
                if (goal instanceof ItemGoal) {
                    int givenQuantity2;
                    ItemGoal itemGoal = (ItemGoal)goal;
                    ItemStack stack = player.m_21120_(hand);
                    if (stack.m_41720_().equals(itemGoal.item) && (givenQuantity2 = Math.min(stack.m_41613_(), itemGoal.amount - itemGoal.deliveredAmount)) > 0) {
                        if (!this.f_58857_.f_46443_) {
                            itemGoal.deliveredAmount += givenQuantity2;
                            stack.m_41774_(givenQuantity2);
                            if (itemGoal.deliveredAmount >= itemGoal.amount) {
                                itemGoal.setCompleted(true);
                            }
                        }
                        isSuccessful = true;
                    }
                }
                if (!(goal instanceof ExperienceGoal)) continue;
                ExperienceGoal experienceGoal = (ExperienceGoal)goal;
                if (!hand.equals((Object)InteractionHand.MAIN_HAND) || !player.m_21120_(hand).m_41619_() || (givenQuantity = Math.min(player.f_36079_, experienceGoal.amount - experienceGoal.deliveredAmount)) <= 0) continue;
                if (!this.f_58857_.f_46443_) {
                    experienceGoal.deliveredAmount += givenQuantity;
                    player.m_6756_(-givenQuantity);
                    if (experienceGoal.deliveredAmount >= experienceGoal.amount) {
                        experienceGoal.setCompleted(true);
                    }
                }
                isSuccessful = true;
            }
            if (isSuccessful) {
                boolean isCompleted = this.goals.stream().allMatch(VoidDepotGoal::isCompleted);
                if (isCompleted) {
                    this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), 40);
                    if (this.oncePerPlayer) {
                        this.playersWhoCompleted.add(player.m_20148_());
                    }
                }
                RandomSource random = this.f_58857_.f_46441_;
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.VOID_EATS_GUNK.get(), SoundSource.PLAYERS, 0.7f, 0.6f + random.m_188501_() * 0.3f);
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.7f, 0.6f + random.m_188501_() * 0.2f);
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, (random.m_188501_() - random.m_188501_()) * 0.35f + 0.9f);
                BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.m_58899_());
                return InteractionResult.SUCCESS;
            }
        }
        return super.onUse(player, hand);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            BlockPos blockPos;
            Player nearestPlayer;
            WeepingWellParticleEffects.passiveVoidDepotParticles(this);
            if ((float)this.f_58857_.m_46467_() % 5.0f == 0.0f && (nearestPlayer = this.f_58857_.m_45924_((double)(blockPos = this.m_58899_()).m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 6.0, false)) != null) {
                this.nearTimer = 10;
            }
            --this.nearTimer;
            if (this.nearTimer > 0 && this.textVisibility < 40.0f) {
                this.textVisibility += 1.0f;
            } else if (this.textVisibility > 0.0f) {
                this.textVisibility -= 1.0f;
            }
        }
    }

    public void onCompletion() {
        float pitch = Mth.m_216267_((RandomSource)this.f_58857_.m_213780_(), (float)1.5f, (float)1.75f);
        ParticleEffectTypeRegistry.WEEPING_WELL_REACTS.createPositionedEffect(this.f_58857_, new PositionEffectData((float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() + 0.9f, (float)this.f_58858_.m_123343_() + 0.5f));
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.FLESH_RING_ABSORBS.get(), SoundSource.HOSTILE, 0.7f, pitch);
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.VOID_TRANSMUTATION.get(), SoundSource.HOSTILE, 2.0f, pitch);
        if (this.repeatable) {
            for (VoidDepotGoal goal : this.goals) {
                goal.reset();
            }
        }
        BlockHelper.updateState((Level)this.f_58857_, (BlockPos)this.m_58899_());
    }

    public static abstract class VoidDepotGoal {
        public final VoidDepotGoalType type;
        public final String index;
        public final int amount;
        public int deliveredAmount;
        public boolean completed;

        public VoidDepotGoal(VoidDepotGoalType type, String index, int amount, int deliveredAmount) {
            this.type = type;
            this.index = index;
            this.amount = amount;
            this.deliveredAmount = deliveredAmount;
        }

        public void setCompleted(boolean completed) {
            this.completed = completed;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void reset() {
            this.deliveredAmount = 0;
            this.completed = false;
        }

        public CompoundTag serialize() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128405_("amount", this.amount);
            compoundTag.m_128405_("deliveredAmount", this.deliveredAmount);
            return compoundTag;
        }

        public static enum VoidDepotGoalType implements StringRepresentable
        {
            ITEM("item", ItemGoal::deserialize),
            EXPERIENCE("experience", ExperienceGoal::deserialize);

            public final String name;
            public final Function<CompoundTag, VoidDepotGoal> deserializer;

            private VoidDepotGoalType(String name, Function<CompoundTag, VoidDepotGoal> deserializer) {
                this.name = name;
                this.deserializer = deserializer;
            }

            public String m_7912_() {
                return this.name;
            }
        }
    }

    public static class ItemGoal
    extends VoidDepotGoal {
        public final Item item;

        public ItemGoal(String index, Item item, int amount, int deliveredAmount) {
            super(VoidDepotGoal.VoidDepotGoalType.ITEM, index, amount, deliveredAmount);
            this.item = item;
        }

        @Override
        public CompoundTag serialize() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("itemType", ForgeRegistries.ITEMS.getKey((Object)this.item).toString());
            compoundTag.m_128405_("amount", this.amount);
            compoundTag.m_128405_("deliveredAmount", this.deliveredAmount);
            return compoundTag;
        }

        public static ItemGoal deserialize(CompoundTag compoundTag) {
            return new ItemGoal(compoundTag.m_128461_("goalName"), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compoundTag.m_128461_("itemType"))), compoundTag.m_128451_("amount"), compoundTag.m_128451_("deliveredAmount"));
        }
    }

    public static class ExperienceGoal
    extends VoidDepotGoal {
        public ExperienceGoal(String index, int amount, int deliveredAmount) {
            super(VoidDepotGoal.VoidDepotGoalType.EXPERIENCE, index, amount, deliveredAmount);
        }

        public static ExperienceGoal deserialize(CompoundTag compoundTag) {
            return new ExperienceGoal(compoundTag.m_128461_("goalName"), compoundTag.m_128451_("amount"), compoundTag.m_128451_("deliveredAmount"));
        }
    }
}

