/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.capability;

import com.sammy.malum.MalumMod;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import team.lodestar.lodestone.systems.capability.LodestoneCapability;
import team.lodestar.lodestone.systems.capability.LodestoneCapabilityProvider;

public class MalumItemDataCapability
implements LodestoneCapability {
    public List<ItemStack> soulsToDrop;
    public UUID attackerForSouls;
    public static Capability<MalumItemDataCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<MalumItemDataCapability>(){});

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(MalumItemDataCapability.class);
    }

    public static void attachItemCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ItemEntity) {
            MalumItemDataCapability capability = new MalumItemDataCapability();
            event.addCapability(MalumMod.malumPath("item_data"), (ICapabilityProvider)new LodestoneCapabilityProvider(CAPABILITY, () -> capability));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.soulsToDrop != null) {
            ListTag souls = new ListTag();
            for (ItemStack soul : this.soulsToDrop) {
                souls.add((Object)soul.serializeNBT());
            }
            tag.m_128365_("soulsToDrop", (Tag)souls);
        }
        if (this.attackerForSouls != null) {
            tag.m_128362_("attacker", this.attackerForSouls);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("soulsToDrop", 9)) {
            this.soulsToDrop = new ArrayList<ItemStack>();
            ListTag souls = tag.m_128437_("soulsToDrop", 10);
            for (int i = 0; i < souls.size(); ++i) {
                this.soulsToDrop.add(ItemStack.m_41712_((CompoundTag)souls.m_128728_(i)));
            }
        } else {
            this.soulsToDrop = null;
        }
        this.attackerForSouls = tag.m_128403_("attacker") ? tag.m_128342_("attacker") : null;
    }

    public static LazyOptional<MalumItemDataCapability> getCapabilityOptional(ItemEntity entity) {
        return entity.getCapability(CAPABILITY);
    }

    public static MalumItemDataCapability getCapability(ItemEntity entity) {
        return (MalumItemDataCapability)entity.getCapability(CAPABILITY).orElse((Object)new MalumItemDataCapability());
    }
}

