/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.capability;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.packets.SyncLivingCapabilityDataPacket;
import com.sammy.malum.core.handlers.MalignantConversionHandler;
import com.sammy.malum.core.handlers.SoulDataHandler;
import com.sammy.malum.core.handlers.TouchOfDarknessHandler;
import com.sammy.malum.registry.common.PacketRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.network.PacketDistributor;
import team.lodestar.lodestone.systems.capability.LodestoneCapability;
import team.lodestar.lodestone.systems.capability.LodestoneCapabilityProvider;

public class MalumLivingEntityDataCapability
implements LodestoneCapability {
    public static Capability<MalumLivingEntityDataCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<MalumLivingEntityDataCapability>(){});
    public SoulDataHandler soulData = new SoulDataHandler();
    public MalignantConversionHandler malignantConversionHandler = new MalignantConversionHandler();
    public TouchOfDarknessHandler touchOfDarknessHandler = new TouchOfDarknessHandler();
    public int watcherNecklaceCooldown;
    public int hiddenBladeCounterCooldown;
    public List<ItemStack> soulsToApplyToDrops;
    public UUID killerUUID;

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(MalumLivingEntityDataCapability.class);
    }

    public static void attachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            MalumLivingEntityDataCapability capability = new MalumLivingEntityDataCapability();
            event.addCapability(MalumMod.malumPath("living_data"), (ICapabilityProvider)new LodestoneCapabilityProvider(CAPABILITY, () -> capability));
        }
    }

    public static void syncEntityCapability(PlayerEvent.StartTracking event) {
        LivingEntity livingEntity;
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_9236_() instanceof ServerLevel) {
            MalumLivingEntityDataCapability.syncTracking(livingEntity);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("soulData", (Tag)this.soulData.serializeNBT());
        tag.m_128365_("darknessAfflictionData", (Tag)this.touchOfDarknessHandler.serializeNBT());
        if (this.watcherNecklaceCooldown > 0) {
            tag.m_128405_("watcherNecklaceCooldown", this.watcherNecklaceCooldown);
        }
        if (this.hiddenBladeCounterCooldown > 0) {
            tag.m_128405_("hiddenBladeCounterCooldown", this.hiddenBladeCounterCooldown);
        }
        if (this.soulsToApplyToDrops != null) {
            ListTag souls = new ListTag();
            for (ItemStack soul : this.soulsToApplyToDrops) {
                souls.add((Object)soul.serializeNBT());
            }
            tag.m_128365_("soulsToApplyToDrops", (Tag)souls);
        }
        if (this.killerUUID != null) {
            tag.m_128362_("killerUUID", this.killerUUID);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_("soulData")) {
            this.soulData.deserializeNBT(tag.m_128469_("soulData"));
        }
        if (tag.m_128441_("darknessAfflictionData")) {
            this.touchOfDarknessHandler.deserializeNBT(tag.m_128469_("darknessAfflictionData"));
        }
        this.watcherNecklaceCooldown = tag.m_128441_("watcherNecklaceCooldown") ? tag.m_128451_("watcherNecklaceCooldown") : 0;
        int n = this.hiddenBladeCounterCooldown = tag.m_128441_("hiddenBladeCounterCooldown") ? tag.m_128451_("hiddenBladeCounterCooldown") : 0;
        if (tag.m_128425_("soulsToApplyToDrops", 9)) {
            this.soulsToApplyToDrops = new ArrayList<ItemStack>();
            ListTag souls = tag.m_128437_("soulsToApplyToDrops", 10);
            for (int i = 0; i < souls.size(); ++i) {
                this.soulsToApplyToDrops.add(ItemStack.m_41712_((CompoundTag)souls.m_128728_(i)));
            }
        } else {
            this.soulsToApplyToDrops = null;
        }
        this.killerUUID = tag.m_128403_("killerUUID") ? tag.m_128342_("killerUUID") : null;
    }

    public static void syncSelf(ServerPlayer player) {
        MalumLivingEntityDataCapability.sync((LivingEntity)player, PacketDistributor.PLAYER.with(() -> player));
    }

    public static void syncTrackingAndSelf(ServerPlayer player) {
        MalumLivingEntityDataCapability.sync((LivingEntity)player, PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player));
    }

    public static void syncTracking(LivingEntity entity) {
        MalumLivingEntityDataCapability.sync(entity, PacketDistributor.TRACKING_ENTITY.with(() -> entity));
    }

    public static void sync(LivingEntity entity, PacketDistributor.PacketTarget target) {
        MalumLivingEntityDataCapability.getCapabilityOptional(entity).ifPresent(c -> PacketRegistry.MALUM_CHANNEL.send(target, (Object)new SyncLivingCapabilityDataPacket(entity.m_19879_(), c.serializeNBT())));
    }

    public static LazyOptional<MalumLivingEntityDataCapability> getCapabilityOptional(LivingEntity entity) {
        return entity.getCapability(CAPABILITY);
    }

    public static MalumLivingEntityDataCapability getCapability(LivingEntity entity) {
        return (MalumLivingEntityDataCapability)entity.getCapability(CAPABILITY).orElse((Object)new MalumLivingEntityDataCapability());
    }
}

