/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.capability;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.packets.SyncMalumPlayerCapabilityDataPacket;
import com.sammy.malum.core.handlers.ReserveStaffChargeHandler;
import com.sammy.malum.core.handlers.SoulWardHandler;
import com.sammy.malum.registry.common.PacketRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.network.PacketDistributor;
import team.lodestar.lodestone.systems.capability.LodestoneCapability;
import team.lodestar.lodestone.systems.capability.LodestoneCapabilityProvider;

public class MalumPlayerDataCapability
implements LodestoneCapability {
    public static Capability<MalumPlayerDataCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<MalumPlayerDataCapability>(){});
    public SoulWardHandler soulWardHandler = new SoulWardHandler();
    public ReserveStaffChargeHandler reserveStaffChargeHandler = new ReserveStaffChargeHandler();
    public boolean obtainedEncyclopedia;
    public boolean hasBeenRejected;

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(MalumPlayerDataCapability.class);
    }

    public static void attachPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            MalumPlayerDataCapability capability = new MalumPlayerDataCapability();
            event.addCapability(MalumMod.malumPath("player_data"), (ICapabilityProvider)new LodestoneCapabilityProvider(CAPABILITY, () -> capability));
        }
    }

    public static void playerJoin(EntityJoinLevelEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (player = (Player)entity) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MalumPlayerDataCapability.syncSelf(serverPlayer);
        }
    }

    public static void syncPlayerCapability(PlayerEvent.StartTracking event) {
        Player player;
        Entity entity = event.getTarget();
        if (entity instanceof Player && (player = (Player)entity).m_9236_() instanceof ServerLevel) {
            MalumPlayerDataCapability.syncTracking(player);
        }
    }

    public static void playerClone(PlayerEvent.Clone event) {
        Player player = event.getOriginal();
        if (player instanceof ServerPlayer) {
            ServerPlayer oldPlayer = (ServerPlayer)player;
            player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer newPlayer = (ServerPlayer)player;
                oldPlayer.reviveCaps();
                MalumPlayerDataCapability.getCapabilityOptional((Player)oldPlayer).ifPresent(oldCapability -> MalumPlayerDataCapability.getCapabilityOptional((Player)newPlayer).ifPresent(newCapability -> newCapability.deserializeNBT(oldCapability.serializeNBT())));
                oldPlayer.invalidateCaps();
            }
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("soulWardData", (Tag)this.soulWardHandler.serializeNBT());
        tag.m_128365_("staffChargeData", (Tag)this.reserveStaffChargeHandler.serializeNBT());
        tag.m_128379_("obtainedEncyclopedia", this.obtainedEncyclopedia);
        tag.m_128379_("hasBeenRejected", this.hasBeenRejected);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_("soulWardData")) {
            this.soulWardHandler.deserializeNBT(tag.m_128469_("soulWardData"));
        }
        if (tag.m_128441_("staffChargeData")) {
            this.reserveStaffChargeHandler.deserializeNBT(tag.m_128469_("staffChargeData"));
        }
        this.obtainedEncyclopedia = tag.m_128471_("obtainedEncyclopedia");
        this.hasBeenRejected = tag.m_128471_("hasBeenRejected");
    }

    public static void syncSelf(ServerPlayer player) {
        MalumPlayerDataCapability.sync((Player)player, PacketDistributor.PLAYER.with(() -> player));
    }

    public static void syncTrackingAndSelf(Player player) {
        MalumPlayerDataCapability.sync(player, PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player));
    }

    public static void syncTracking(Player player) {
        MalumPlayerDataCapability.sync(player, PacketDistributor.TRACKING_ENTITY.with(() -> player));
    }

    public static void sync(Player player, PacketDistributor.PacketTarget target) {
        MalumPlayerDataCapability.getCapabilityOptional(player).ifPresent(c -> PacketRegistry.MALUM_CHANNEL.send(target, (Object)new SyncMalumPlayerCapabilityDataPacket(player.m_20148_(), c.serializeNBT())));
    }

    public static LazyOptional<MalumPlayerDataCapability> getCapabilityOptional(Player player) {
        return player.getCapability(CAPABILITY);
    }

    public static MalumPlayerDataCapability getCapability(Player player) {
        return (MalumPlayerDataCapability)player.getCapability(CAPABILITY).orElse((Object)new MalumPlayerDataCapability());
    }
}

