/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public abstract class FloatingEntity
extends Entity {
    public final TrailPointBuilder trail = TrailPointBuilder.create((int)10);
    public int age;
    public int maxAge;
    public float windUp;
    public float hoverOffset;
    public UUID ownerUUID;
    public LivingEntity owner;

    public FloatingEntity(EntityType<? extends FloatingEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = false;
        this.hoverOffset = (float)(Math.random() * Math.PI * 2.0);
    }

    public void spawnParticles(double x, double y, double z) {
    }

    public Vec3 getDestination() {
        if (this.owner != null) {
            return this.owner.m_20182_().m_82520_(0.0, (double)(this.owner.m_20206_() / 3.0f), 0.0);
        }
        return null;
    }

    public abstract void collect();

    public abstract float getMotionCoefficient();

    public float getFriction() {
        return 0.95f;
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("age", this.age);
        compound.m_128405_("maxAge", this.maxAge);
        compound.m_128350_("windUp", this.windUp);
        if (this.ownerUUID != null) {
            compound.m_128362_("ownerUUID", this.ownerUUID);
        }
    }

    public void m_7378_(CompoundTag compound) {
        this.age = compound.m_128451_("age");
        this.maxAge = compound.m_128451_("maxAge");
        this.windUp = compound.m_128457_("windUp");
        if (compound.m_128441_("ownerUUID")) {
            this.setOwner(compound.m_128342_("ownerUUID"));
        }
    }

    public void m_8119_() {
        BlockHitResult result;
        super.m_8119_();
        this.m_6075_();
        this.hoverOffset = this.getHoverStart(0.0f);
        ++this.age;
        if (this.age > this.maxAge) {
            this.m_146870_();
        }
        float friction = this.getFriction();
        this.m_20256_(this.m_20184_().m_82542_((double)friction, (double)friction, (double)friction));
        if (this.m_6084_()) {
            Vec3 destination;
            Player playerEntity;
            if (!(this.owner != null && this.owner.m_6084_() || this.m_9236_().m_46467_() % 40L != 0L || (playerEntity = this.m_9236_().m_45930_((Entity)this, 50.0)) == null)) {
                this.setOwner(playerEntity.m_20148_());
            }
            if ((destination = this.getDestination()) != null) {
                if (this.windUp < 1.0f) {
                    this.windUp += 0.02f;
                }
                float velocity = Mth.m_14036_((float)(this.windUp - 0.25f), (float)0.0f, (float)0.75f) * 5.0f;
                Vec3 desiredMotion = destination.m_82546_(this.m_20182_()).m_82541_().m_82542_((double)velocity, (double)velocity, (double)velocity);
                float easing = this.getMotionCoefficient();
                float xMotion = (float)Mth.m_14139_((double)easing, (double)this.m_20184_().f_82479_, (double)desiredMotion.f_82479_);
                float yMotion = (float)Mth.m_14139_((double)easing, (double)this.m_20184_().f_82480_, (double)desiredMotion.f_82480_);
                float zMotion = (float)Mth.m_14139_((double)easing, (double)this.m_20184_().f_82481_, (double)desiredMotion.f_82481_);
                Vec3 resultingMotion = new Vec3((double)xMotion, (double)yMotion, (double)zMotion);
                this.m_20256_(resultingMotion);
                float distance = (float)this.m_20238_(destination);
                if (distance < 0.4f) {
                    this.collect();
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
            }
        }
        if ((result = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82549_(this.m_20184_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this))).m_6662_() == HitResult.Type.BLOCK) {
            BlockEntity blockentity;
            BlockPos blockpos = result.m_82425_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (blockstate.m_60713_(Blocks.f_50142_)) {
                this.m_20221_(blockpos);
            } else if (blockstate.m_60713_(Blocks.f_50446_) && (blockentity = this.m_9236_().m_7702_(blockpos)) instanceof TheEndGatewayBlockEntity && TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                TheEndGatewayBlockEntity.m_155828_((Level)this.m_9236_(), (BlockPos)blockpos, (BlockState)blockstate, (Entity)this, (TheEndGatewayBlockEntity)((TheEndGatewayBlockEntity)blockentity));
            }
        }
        this.m_20101_();
        Vec3 movement = this.m_20184_();
        double nextX = this.m_20185_() + movement.f_82479_;
        double nextY = this.m_20186_() + movement.f_82480_;
        double nextZ = this.m_20189_() + movement.f_82481_;
        double distance = movement.m_165924_();
        float xRot = FloatingEntity.lerpRotation(this.f_19860_, (float)(Mth.m_14136_((double)movement.f_82480_, (double)distance) * 57.2957763671875));
        float yRot = FloatingEntity.lerpRotation(this.f_19859_, (float)(Mth.m_14136_((double)movement.f_82479_, (double)movement.f_82481_) * 57.2957763671875));
        this.m_146926_(xRot);
        this.m_146922_(yRot);
        this.m_6034_(nextX, nextY, nextZ);
        ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
        if (this.m_9236_().f_46443_) {
            this.spawnParticles(this.f_19790_, this.f_19791_ + (double)this.getYOffset(0.0f), this.f_19792_);
            for (int i = 0; i < 2; ++i) {
                float progress = (float)(i + 1) * 0.5f;
                Vec3 position = this.m_20318_(progress).m_82520_(0.0, (double)this.getYOffset(progress), 0.0);
                this.trail.addTrailPoint(position);
            }
            this.trail.tickTrailPoints();
        }
    }

    public void m_6001_(double pX, double pY, double pZ) {
        this.m_20334_(pX, pY, pZ);
        this.m_146867_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.owner == null ? 0 : this.owner.m_19879_());
    }

    protected static float lerpRotation(float p_37274_, float p_37275_) {
        while (p_37275_ - p_37274_ < -180.0f) {
            p_37274_ -= 360.0f;
        }
        while (p_37275_ - p_37274_ >= 180.0f) {
            p_37274_ += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)p_37274_, (float)p_37275_);
    }

    public float getYOffset(float partialTicks) {
        return Mth.m_14031_((float)(((float)this.age + partialTicks) / 10.0f + this.getHoverStart(partialTicks))) * 0.1f + 0.35f;
    }

    public float getRotation(float partialTicks) {
        return ((float)this.age + partialTicks) / 20.0f + this.getHoverStart(partialTicks) / 2.0f;
    }

    public float getHoverStart(float partialTicks) {
        return this.hoverOffset + (1.0f - Easing.SINE_OUT.ease(Math.min(1.0f, ((float)this.age + partialTicks) / 60.0f), 0.0f, 1.0f, 1.0f)) * 0.35f;
    }

    public void setOwner(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.owner = (LivingEntity)serverLevel.m_8791_(ownerUUID);
        }
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }
}

