/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.bolt;

import com.sammy.malum.registry.common.DamageTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import com.sammy.malum.visual_effects.networked.staff.HexBoltImpactParticleEffect;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.ItemHelper;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public abstract class AbstractBoltProjectileEntity
extends ThrowableItemProjectile {
    protected static final EntityDataAccessor<Boolean> DATA_FADING_AWAY = SynchedEntityData.m_135353_(AbstractBoltProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> DATA_SPAWN_DELAY = SynchedEntityData.m_135353_(AbstractBoltProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final TrailPointBuilder trailPointBuilder = TrailPointBuilder.create((int)8);
    public final TrailPointBuilder spinningTrailPointBuilder = TrailPointBuilder.create((int)16);
    public float spinOffset = (float)((double)this.f_19796_.m_188501_() * Math.PI * 2.0);
    protected float magicDamage;
    public int age;
    public int spawnDelay;
    public boolean fadingAway;
    public int fadingTimer;

    public AbstractBoltProjectileEntity(EntityType<? extends AbstractBoltProjectileEntity> pEntityType, Level level) {
        super(pEntityType, level);
        this.f_19794_ = false;
    }

    public void setData(Entity owner, float magicDamage, int spawnDelay) {
        this.m_5602_(owner);
        this.magicDamage = magicDamage;
        this.m_20088_().m_135381_(DATA_SPAWN_DELAY, (Object)spawnDelay);
        if (!this.m_9236_().f_46443_ && spawnDelay == 0) {
            this.m_5496_((SoundEvent)SoundRegistry.STAFF_FIRES.get(), 0.5f, Mth.m_216267_((RandomSource)this.f_19796_, (float)0.9f, (float)1.5f));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void spawnParticles();

    public abstract int getMaxAge();

    public abstract ParticleEffectType getImpactParticleEffect();

    public float getOrbitingTrailDistance() {
        return 0.3f;
    }

    public void onDealDamage(LivingEntity target) {
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_FADING_AWAY, (Object)false);
        this.m_20088_().m_135372_(DATA_SPAWN_DELAY, (Object)0);
        super.m_8097_();
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_FADING_AWAY.equals(pKey)) {
            this.fadingAway = (Boolean)this.f_19804_.m_135370_(DATA_FADING_AWAY);
            if (this.fadingAway) {
                this.age = this.getMaxAge() - 10;
                this.m_20256_(this.m_20184_().m_82490_((double)0.02f));
            }
        }
        if (DATA_SPAWN_DELAY.equals(pKey)) {
            this.spawnDelay = (Integer)this.f_19804_.m_135370_(DATA_SPAWN_DELAY);
        }
        super.m_7350_(pKey);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.magicDamage != 0.0f) {
            compound.m_128350_("magicDamage", this.magicDamage);
        }
        if (this.age != 0) {
            compound.m_128405_("age", this.age);
        }
        if (this.spawnDelay != 0) {
            compound.m_128405_("spawnDelay", this.spawnDelay);
        }
        if (this.fadingAway) {
            compound.m_128379_("fadingAway", true);
            compound.m_128405_("fadingTimer", this.fadingTimer);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.magicDamage = compound.m_128457_("magicDamage");
        this.age = compound.m_128451_("age");
        this.m_20088_().m_135381_(DATA_SPAWN_DELAY, (Object)compound.m_128451_("spawnDelay"));
        this.m_20088_().m_135381_(DATA_FADING_AWAY, (Object)compound.m_128471_("fadingAway"));
    }

    protected void m_8060_(BlockHitResult pResult) {
        if (this.fadingAway || this.spawnDelay > 0) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.getImpactParticleEffect().createPositionedEffect(this.m_9236_(), new PositionEffectData(this.m_20182_().m_82549_(this.m_20184_().m_82490_(0.25))), new ColorEffectData(SpiritTypeRegistry.WICKED_SPIRIT), HexBoltImpactParticleEffect.createData(this.m_20184_().m_82548_().m_82541_()));
            this.m_5496_((SoundEvent)SoundRegistry.STAFF_STRIKES.get(), 0.5f, Mth.m_216267_((RandomSource)this.f_19796_, (float)0.9f, (float)1.5f));
            this.m_20088_().m_135381_(DATA_FADING_AWAY, (Object)true);
            Vec3 direction = pResult.m_82450_().m_82546_(this.m_20182_());
            Vec3 offset = direction.m_82541_().m_82490_(0.5);
            this.m_20343_(this.m_20185_() - offset.f_82479_, this.m_20186_() - offset.f_82480_, this.m_20189_() - offset.f_82481_);
        }
        super.m_8060_(pResult);
    }

    protected boolean m_5603_(Entity pTarget) {
        if (pTarget.equals((Object)this.m_19749_())) {
            return false;
        }
        if (pTarget instanceof AbstractBoltProjectileEntity) {
            return false;
        }
        return super.m_5603_(pTarget);
    }

    protected void m_5790_(EntityHitResult result) {
        if (this.m_9236_().f_46443_ || this.fadingAway || this.spawnDelay > 0) {
            return;
        }
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity staffOwner = (LivingEntity)entity;
            Entity target = result.m_82443_();
            target.f_19802_ = 0;
            DamageSource source = DamageTypeHelper.create((Level)this.m_9236_(), DamageTypeRegistry.VOODOO, (Entity)this, (Entity)staffOwner);
            boolean success = target.m_6469_(source, this.magicDamage);
            if (success && target instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)target;
                this.onDealDamage(livingentity);
                ItemStack staff = this.m_7846_();
                ItemHelper.applyEnchantments((LivingEntity)staffOwner, (Entity)livingentity, (ItemStack)staff);
                int i = staff.getEnchantmentLevel(Enchantments.f_44981_);
                if (i > 0) {
                    livingentity.m_20254_(i * 4);
                }
                this.m_20088_().m_135381_(DATA_FADING_AWAY, (Object)true);
                this.getImpactParticleEffect().createPositionedEffect(this.m_9236_(), new PositionEffectData(this.m_20182_().m_82549_(this.m_20184_().m_82490_(0.5))), new ColorEffectData(SpiritTypeRegistry.WICKED_SPIRIT), HexBoltImpactParticleEffect.createData(this.m_20184_().m_82548_().m_82541_()));
                this.m_5496_((SoundEvent)SoundRegistry.STAFF_STRIKES.get(), 0.75f, Mth.m_216267_((RandomSource)this.f_19796_, (float)1.0f, (float)1.4f));
                this.m_20256_(this.m_20184_().m_82490_((double)0.05f));
            }
        }
        super.m_5790_(result);
    }

    public void m_8119_() {
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            if (this.spawnDelay == 0 && !this.m_9236_().f_46443_) {
                this.spawnDelay = -1;
                this.m_5496_((SoundEvent)SoundRegistry.STAFF_FIRES.get(), 0.5f, Mth.m_216267_((RandomSource)this.f_19796_, (float)0.9f, (float)1.5f));
            }
            return;
        }
        super.m_8119_();
        ++this.age;
        if (this.fadingAway) {
            ++this.fadingTimer;
        } else {
            Vec3 motion = this.m_20184_();
            float scalar = 0.96f;
            this.m_20334_(motion.f_82479_ * (double)scalar, (motion.f_82480_ - (double)0.015f) * (double)scalar, motion.f_82481_ * (double)scalar);
        }
        if (this.m_9236_().f_46443_) {
            float offsetScale = this.fadingAway ? 0.0f : this.getOrbitingTrailDistance();
            for (int i = 0; i < 2; ++i) {
                float progress = (float)(i + 1) * 0.5f;
                Vec3 position = this.m_20318_(progress);
                float scalar = ((float)this.age + progress) / 2.0f;
                double xOffset = Math.cos(this.spinOffset + scalar) * (double)offsetScale;
                double zOffset = Math.sin(this.spinOffset + scalar) * (double)offsetScale;
                this.trailPointBuilder.addTrailPoint(position);
                this.spinningTrailPointBuilder.addTrailPoint(position.m_82520_(xOffset, 0.0, zOffset));
            }
            this.trailPointBuilder.tickTrailPoints();
            this.spinningTrailPointBuilder.tickTrailPoints();
            if (!this.fadingAway) {
                this.spawnParticles();
            }
        } else if (this.age >= this.getMaxAge()) {
            if (this.fadingAway) {
                this.m_146870_();
            } else {
                this.m_20088_().m_135381_(DATA_FADING_AWAY, (Object)true);
            }
        }
    }

    public void m_6001_(double pX, double pY, double pZ) {
        this.m_20334_(pX, pY, pZ);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = Math.sqrt(pX * pX + pZ * pZ);
            this.m_146926_((float)(Mth.m_14136_((double)pY, (double)d0) * 57.2957763671875));
            this.m_146922_((float)(Mth.m_14136_((double)pX, (double)pZ) * 57.2957763671875));
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            this.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
        }
    }

    public void m_37251_(Entity shooter, float rotationPitch, float rotationYaw, float pitchOffset, float velocity, float innacuracy) {
        float f = -Mth.m_14031_((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitch * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((rotationPitch + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(rotationYaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitch * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, velocity, innacuracy);
    }

    public float getVisualEffectScalar() {
        float effectScalar = 1.0f;
        if (this.age < 5) {
            effectScalar = (float)this.age / 5.0f;
        } else if (this.fadingAway) {
            effectScalar /= (float)(this.fadingTimer + 2) / 2.0f;
        }
        return effectScalar;
    }

    public boolean m_20069_() {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    public float m_6143_() {
        return 4.0f;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6128_() {
        return true;
    }
}

