/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.bolt;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.common.item.curiosities.weapons.staff.AuricFlameStaffItem;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.entity.EntityRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.SparkBehaviorComponent;

public class AuricFlameBoltEntity
extends AbstractBoltProjectileEntity {
    public AuricFlameBoltEntity(Level level) {
        super((EntityType<? extends AbstractBoltProjectileEntity>)((EntityType)EntityRegistry.AURIC_FLAME_BOLT.get()), level);
        this.f_19794_ = false;
    }

    public AuricFlameBoltEntity(Level level, double pX, double pY, double pZ) {
        this(level);
        this.m_6034_(pX, pY, pZ);
        this.f_19794_ = false;
    }

    @Override
    protected void m_8060_(BlockHitResult pResult) {
        AABB boundingBox = this.m_20191_();
        this.m_20011_(boundingBox.m_82406_(0.5));
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
        if (hitresult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitresult;
            super.m_8060_(blockHitResult);
        }
        this.m_20011_(boundingBox);
    }

    @Override
    protected void m_5790_(EntityHitResult result) {
        if (this.fadingAway || this.spawnDelay > 0) {
            return;
        }
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            livingentity.m_20254_(4);
        }
        super.m_5790_(result);
    }

    public void m_5496_(SoundEvent pSound, float pVolume, float pPitch) {
        super.m_5496_(pSound, pVolume, pPitch);
        super.m_5496_((SoundEvent)SoundRegistry.AURIC_FLAME_MOTIF.get(), pVolume + 0.1f, pPitch + 0.6f);
    }

    @Override
    public int getMaxAge() {
        return 80;
    }

    @Override
    public ParticleEffectType getImpactParticleEffect() {
        return ParticleEffectTypeRegistry.AURIC_BOLT_IMPACT;
    }

    protected Item m_7881_() {
        return (Item)ItemRegistry.STAFF_OF_THE_AURIC_FLAME.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        Level level = this.m_9236_();
        Vec3 position = this.m_20182_();
        float scalar = this.getVisualEffectScalar();
        Vec3 norm = this.m_20184_().m_82541_().m_82490_((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, position, AuricFlameStaffItem.AURIC_COLOR_DATA);
        lightSpecs.getBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).multiplyLifetime(1.25f).setMotion(norm);
        lightSpecs.getBloomBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).multiplyLifetime(1.25f).setMotion(norm);
        lightSpecs.spawnParticles();
        Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().m_82490_((double)0.98f));
        float min = Math.min(1.0f, 2.0f * scalar);
        WorldParticleBuilder.create(ParticleRegistry.BOLT, (LodestoneBehaviorComponent)new SparkBehaviorComponent(GenericParticleData.create((float)(2.0f * min), (float)(0.2f * min)).setEasing(Easing.CUBIC_IN).build())).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setTransparencyData(GenericParticleData.create((float)(0.5f * scalar), (float)(0.2f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData(GenericParticleData.create((float)(0.6f * scalar), (float)(0.1f * min)).setEasing(Easing.QUAD_OUT).build()).setColorData(AuricFlameStaffItem.AURIC_COLOR_DATA).setLifetime(Math.min(6 + this.age * 3, 15)).setMotion(norm).enableNoClip().enableForcedSpawn().setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.FIRST_INDEX).addTickActor(behavior).spawn(level, position.f_82479_, position.f_82480_, position.f_82481_).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(level, position.f_82479_, position.f_82480_, position.f_82481_);
    }
}

