/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.bolt;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.common.item.curiosities.weapons.staff.ErosionScepterItem;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.MobEffectRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.entity.EntityRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.DirectionalBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;

public class DrainingBoltEntity
extends AbstractBoltProjectileEntity {
    public DrainingBoltEntity(Level level) {
        super((EntityType<? extends AbstractBoltProjectileEntity>)((EntityType)EntityRegistry.DRAINING_BOLT.get()), level);
        this.f_19794_ = false;
    }

    public DrainingBoltEntity(Level level, double pX, double pY, double pZ) {
        this(level);
        this.m_6034_(pX, pY, pZ);
        this.f_19794_ = false;
    }

    @Override
    public void onDealDamage(LivingEntity target) {
        MobEffect silenced = (MobEffect)MobEffectRegistry.SILENCED.get();
        MobEffectInstance effect = target.m_21124_(silenced);
        if (effect == null) {
            target.m_7292_(new MobEffectInstance(silenced, 300, 0, true, true, true));
        } else {
            EntityHelper.amplifyEffect((MobEffectInstance)effect, (LivingEntity)target, (int)1, (int)9);
            EntityHelper.extendEffect((MobEffectInstance)effect, (LivingEntity)target, (int)30, (int)600);
        }
    }

    public void m_5496_(SoundEvent pSound, float pVolume, float pPitch) {
        super.m_5496_(pSound, pVolume, pPitch - 0.2f);
        super.m_5496_((SoundEvent)SoundRegistry.DRAINING_MOTIF.get(), pVolume, pPitch - 0.1f);
    }

    @Override
    public int getMaxAge() {
        return 30;
    }

    @Override
    public float getOrbitingTrailDistance() {
        return 0.5f;
    }

    @Override
    public ParticleEffectType getImpactParticleEffect() {
        return ParticleEffectTypeRegistry.DRAINING_BOLT_IMPACT;
    }

    protected Item m_7881_() {
        return (Item)ItemRegistry.EROSION_SCEPTER.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        Level level = this.m_9236_();
        Vec3 position = this.m_20182_();
        float scalar = this.getVisualEffectScalar();
        Vec3 norm = this.m_20184_().m_82541_().m_82490_((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, position, ErosionScepterItem.MALIGNANT_COLOR_DATA);
        lightSpecs.getBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).multiplyLifetime(1.5f).setMotion(norm);
        lightSpecs.getBloomBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).multiplyLifetime(1.5f).setMotion(norm);
        lightSpecs.spawnParticles();
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)this.f_19796_, (float)RandomHelper.randomBetween((RandomSource)this.f_19796_, (float)0.25f, (float)0.5f)).randomSpinOffset(this.f_19796_).build();
        Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().m_82490_((double)0.95f));
        WorldParticleBuilder.create(ParticleRegistry.SAW, (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(this.m_20184_().m_82541_())).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setTransparencyData(GenericParticleData.create((float)(0.4f * scalar), (float)(0.2f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData(spinData).setScaleData(GenericParticleData.create((float)(0.3f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(ErosionScepterItem.MALIGNANT_COLOR_DATA).setLifetime(Math.min(6 + this.age * 3, 24)).enableNoClip().enableForcedSpawn().addTickActor(behavior).spawn(level, position.f_82479_, position.f_82480_, position.f_82481_).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setTransparencyData(GenericParticleData.create((float)(0.9f * scalar), (float)(0.4f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).spawn(level, position.f_82479_, position.f_82480_, position.f_82481_);
    }
}

