/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.hidden_blade;

import com.sammy.malum.registry.common.DamageTypeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.entity.EntityRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.ItemHelper;
import team.lodestar.lodestone.helpers.SoundHelper;

public class HiddenBladeDelayedImpactEntity
extends ThrowableItemProjectile {
    protected float damage;
    protected float magicDamage;
    public int age;
    public int duration = 25;
    public int enemiesHit;

    public HiddenBladeDelayedImpactEntity(Level level) {
        super((EntityType)EntityRegistry.HIDDEN_BLADE_DELAYED_IMPACT.get(), level);
        this.f_19794_ = false;
    }

    public HiddenBladeDelayedImpactEntity(Level level, double pX, double pY, double pZ) {
        super((EntityType)EntityRegistry.HIDDEN_BLADE_DELAYED_IMPACT.get(), pX, pY, pZ, level);
        this.f_19794_ = false;
    }

    public void setData(Entity owner, float damage, float magicDamage, int duration) {
        this.m_5602_(owner);
        this.damage = damage;
        this.magicDamage = magicDamage;
        this.duration = duration;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.damage != 0.0f) {
            compound.m_128350_("damage", this.damage);
        }
        if (this.magicDamage != 0.0f) {
            compound.m_128350_("magicDamage", this.magicDamage);
        }
        if (this.age != 0) {
            compound.m_128405_("age", this.age);
        }
        if (this.duration != 0) {
            compound.m_128405_("duration", this.duration);
        }
        if (this.enemiesHit != 0) {
            compound.m_128405_("enemiesHit", this.enemiesHit);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.damage = compound.m_128457_("damage");
        this.magicDamage = compound.m_128457_("magicDamage");
        this.age = compound.m_128451_("age");
        this.duration = compound.m_128451_("duration");
        this.enemiesHit = compound.m_128451_("enemiesHit");
    }

    protected boolean m_5603_(Entity pTarget) {
        return !pTarget.equals((Object)this.m_19749_()) && super.m_5603_(pTarget);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity scytheOwner = (LivingEntity)entity;
            Entity target = result.m_82443_();
            DamageSource source = DamageTypeHelper.create((Level)this.m_9236_(), DamageTypeRegistry.HIDDEN_BLADE_COUNTER, (Entity)this, (Entity)scytheOwner);
            target.f_19802_ = 0;
            Vec3 deltaMovement = target.m_20184_();
            boolean success = target.m_6469_(source, this.damage);
            if (success && target instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)target;
                ItemStack scythe = this.m_7846_();
                ItemHelper.applyEnchantments((LivingEntity)scytheOwner, (Entity)livingentity, (ItemStack)scythe);
                int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)scythe);
                if (i > 0) {
                    livingentity.m_20254_(i * 4);
                }
                if (this.magicDamage > 0.0f && !livingentity.m_21224_()) {
                    target.f_19802_ = 0;
                    livingentity.m_6469_(DamageTypeHelper.create((Level)this.m_9236_(), DamageTypeRegistry.VOODOO, (Entity)this, (Entity)scytheOwner), this.magicDamage);
                }
                ++this.enemiesHit;
            }
            target.m_20256_(deltaMovement);
            SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)SoundRegistry.SCYTHE_CUT.get()), (float)1.0f, (float)(0.9f + this.m_9236_().m_213780_().m_188501_() * 0.2f));
        }
        super.m_5790_(result);
    }

    public void m_8119_() {
        ++this.age;
        if (!this.m_9236_().m_5776_()) {
            for (Entity target : this.m_9236_().m_6249_((Entity)this, this.m_20191_(), this::m_5603_)) {
                this.m_5790_(new EntityHitResult(target));
            }
            if (this.age >= this.duration) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected Item m_7881_() {
        return (Item)ItemRegistry.SOUL_STAINED_STEEL_SCYTHE.get();
    }

    public boolean m_20068_() {
        return true;
    }

    public float m_6143_() {
        return 4.0f;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6128_() {
        return true;
    }
}

