/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.nitrate;

import com.sammy.malum.common.entity.nitrate.AbstractNitrateEntity;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.entity.EntityRegistry;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;

public class VividNitrateEntity
extends AbstractNitrateEntity {
    public static final List<Color> COLORS = new ArrayList<Color>(List.of(new Color(231, 58, 73), new Color(246, 125, 70), new Color(249, 206, 77), new Color(48, 242, 71), new Color(48, 208, 242), new Color(59, 48, 242), new Color(145, 42, 247), new Color(231, 58, 73)));
    public static final Function<ColorFunctionData, Color> COLOR_FUNCTION = f -> {
        float time = ((float)f.level.m_46467_() + f.partialTicks) % f.duration / f.duration;
        float lerp = time + f.offset;
        if (lerp > 1.0f) {
            lerp = (float)((double)lerp - Math.floor(lerp));
        }
        return ColorHelper.multicolorLerp((Easing)Easing.SINE_IN, (float)lerp, COLORS);
    };

    public VividNitrateEntity(Level level) {
        super((EntityType<? extends AbstractNitrateEntity>)((EntityType)EntityRegistry.VIVID_NITRATE.get()), level);
    }

    public VividNitrateEntity(LivingEntity owner, Level level) {
        super((EntityType<? extends AbstractNitrateEntity>)((EntityType)EntityRegistry.VIVID_NITRATE.get()), owner, level);
    }

    @Override
    public float getExplosionRadius() {
        return 3.0f;
    }

    @Override
    public int getMaxPierce() {
        return 20;
    }

    @Override
    public ParticleEffectType getImpactParticleEffect() {
        return ParticleEffectTypeRegistry.ETHERIC_NITRATE_IMPACT;
    }

    @Override
    public ColorEffectData getImpactParticleEffectColor() {
        return new ColorEffectData(COLOR_FUNCTION.apply(new ColorFunctionData(this.m_9236_(), 0.125f)));
    }

    @Override
    public void onExplode() {
        Vec3 deltaMovement = this.m_20184_();
        RandomSource random = this.m_9236_().f_46441_;
        double x = Mth.m_14139_((double)0.5, (double)deltaMovement.f_82479_, (double)Math.min(2.0, (double)(0.9f + random.m_188501_() * 0.3f) * (random.m_188499_() ? -deltaMovement.f_82479_ : deltaMovement.f_82479_) + (double)0.45f - (double)(random.m_188501_() * 0.9f)));
        double y = Mth.m_14139_((double)0.5, (double)deltaMovement.f_82480_, (double)Math.min(2.0, deltaMovement.f_82480_ * (double)(0.7f + random.m_188501_() * 0.3f) + (double)0.2f + (double)(random.m_188501_() * 0.4f)));
        double z = Mth.m_14139_((double)0.5, (double)deltaMovement.f_82481_, (double)Math.min(2.0, (double)(0.9f + random.m_188501_() * 0.3f) * (random.m_188499_() ? -deltaMovement.f_82481_ : deltaMovement.f_82481_) + (double)0.45f - (double)(random.m_188501_() * 0.9f)));
        if (random.m_188501_() < 0.2f) {
            x *= (double)(1.5f + random.m_188501_() * 0.5f);
            y += (double)(0.25f + random.m_188501_() * 0.5f);
            z *= (double)(1.5f + random.m_188501_() * 0.5f);
        }
        y = Math.min(y, 1.0);
        this.m_20334_(x, y, z);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        float scalar;
        float f = scalar = this.age > 1190 ? 1.0f - (float)(this.age - 1200 + 10) / 10.0f : 1.0f;
        if (this.age < 5) {
            scalar = (float)this.age / 5.0f;
        }
        Color color = COLOR_FUNCTION.apply(new ColorFunctionData(this.m_9236_(), 0.0f));
        Vec3 norm = this.m_20184_().m_82541_().m_82490_((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(this.m_9236_(), this.m_20182_(), ColorParticleData.create((Color)color, (Color)color).setEasing(Easing.SINE_IN_OUT).setCoefficient(0.9f).build());
        lightSpecs.getBuilder().multiplyLifetime(1.5f).setMotion(norm);
        lightSpecs.getBloomBuilder().multiplyLifetime(1.5f).setMotion(norm);
        lightSpecs.spawnParticles();
        Color smokeColor = AbstractNitrateEntity.SECOND_SMOKE_COLOR;
        for (int i = 0; i < 3; ++i) {
            color = this.age < 3 ? smokeColor : COLOR_FUNCTION.apply(new ColorFunctionData(this.m_9236_(), (float)i * 0.25f));
            int lifetime = (int)((float)RandomHelper.randomBetween((RandomSource)this.f_19796_, (int)60, (int)80) * (1.0f - (float)i / 3.0f));
            SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)this.f_19796_, (float)0.0f, (float)RandomHelper.randomBetween((RandomSource)this.f_19796_, (float)0.0f, (float)0.4f), (float)0.0f).randomSpinOffset(this.f_19796_).build();
            Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().m_82490_((double)0.98f));
            WorldParticleBuilder.create(ParticleRegistry.STRANGE_SMOKE).setTransparencyData(GenericParticleData.create((float)(0.7f * scalar), (float)(0.9f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData(spinData).setScaleData(GenericParticleData.create((float)(0.2f * scalar), (float)(0.4f * scalar), (float)(0.6f * scalar)).setEasing(Easing.QUINTIC_OUT, Easing.SINE_IN).build()).setColorData(ColorParticleData.create((Color)color, (Color)smokeColor).setEasing(Easing.QUAD_OUT).setCoefficient(1.1f).build()).setLifetime(Math.min(6 + this.age * 3, lifetime)).setLifeDelay(1).enableNoClip().enableForcedSpawn().setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).addTickActor(behavior).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(this.m_9236_(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_);
        }
    }

    public record ColorFunctionData(Level level, float duration, float offset, float partialTicks) {
        public ColorFunctionData(Level level, float offset) {
            this(level, 12.0f, offset, 0.0f);
        }
    }
}

