/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.spirit;

import com.sammy.malum.common.entity.FloatingEntity;
import com.sammy.malum.common.entity.FloatingItemEntity;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.entity.EntityRegistry;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.util.UUID;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.ItemHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;

public class SpiritItemEntity
extends FloatingItemEntity {
    public int soundCooldown;

    public SpiritItemEntity(Level level) {
        super((EntityType<? extends FloatingEntity>)((EntityType)EntityRegistry.NATURAL_SPIRIT.get()), level);
        this.soundCooldown = 20 + this.f_19796_.m_188503_(100);
        this.maxAge = 4000;
    }

    public SpiritItemEntity(Level level, UUID ownerUUID, ItemStack stack, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        this(level);
        this.setOwner(ownerUUID);
        this.setItem(stack);
        this.m_6034_(posX, posY, posZ);
        this.m_20334_(velX, velY, velZ);
        this.maxAge = 800;
        Item item = stack.m_41720_();
        if (item instanceof SpiritShardItem) {
            SpiritShardItem spiritShardItem = (SpiritShardItem)item;
            this.setSpirit(spiritShardItem.type);
        }
    }

    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    @Override
    public void collect() {
        ItemStack stack = this.getItem();
        if (stack.m_41720_() instanceof SpiritShardItem) {
            SpiritHarvestHandler.pickupSpirit(this.owner, stack);
        } else {
            ItemHelper.giveItemToEntity((LivingEntity)this.owner, (ItemStack)stack);
        }
        if (this.f_19796_.m_188501_() < 0.6f) {
            SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)SoundRegistry.SPIRIT_PICKUP.get()), (float)0.3f, (float)Mth.m_216267_((RandomSource)this.f_19796_, (float)1.1f, (float)2.0f));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.soundCooldown-- == 0) {
            if (this.f_19796_.m_188501_() < 0.4f) {
                SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)SoundRegistry.ARCANE_WHISPERS.get()), (float)0.3f, (float)Mth.m_216267_((RandomSource)this.f_19796_, (float)0.8f, (float)2.0f));
            }
            this.soundCooldown = 40 + this.f_19796_.m_188503_(40);
        }
    }

    @Override
    public void spawnParticles(double x, double y, double z) {
        Vec3 motion = this.m_20184_();
        Vec3 norm = motion.m_82541_().m_82490_((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(this.m_9236_(), new Vec3(x, y, z), this.spiritType);
        lightSpecs.getBuilder().setMotion(norm);
        lightSpecs.getBloomBuilder().setMotion(norm);
        lightSpecs.spawnParticles();
    }

    @Override
    public float getMotionCoefficient() {
        return 0.01f;
    }
}

