/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities;

import com.sammy.malum.common.entity.nitrate.AbstractNitrateEntity;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CatalystFlingerItem
extends Item {
    public static final String STATE = "malum:state";
    public static final String STASHED_STATE = "malum:stashed_state";
    public static final String TIMER = "malum:timer";
    public final Function<Player, AbstractNitrateEntity> entitySupplier;

    public CatalystFlingerItem(Item.Properties pProperties, Function<Player, AbstractNitrateEntity> entitySupplier) {
        super(pProperties);
        this.entitySupplier = entitySupplier;
    }

    public boolean m_6832_(ItemStack pStack, ItemStack pRepairCandidate) {
        return pRepairCandidate.m_41720_().equals(ItemRegistry.MALIGNANT_LEAD.get());
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        CompoundTag tag;
        int state;
        if (pStack.m_41782_() && (state = (tag = pStack.m_41783_()).m_128451_(STATE)) != 0) {
            int timer = tag.m_128451_(TIMER);
            if (pIsSelected && timer > 0) {
                tag.m_128473_(TIMER);
                return;
            }
            if (!pIsSelected) {
                ++timer;
            }
            if (timer >= 100) {
                tag.m_128405_(STASHED_STATE, state);
                tag.m_128473_(STATE);
                tag.m_128473_(TIMER);
                pEntity.m_5496_((SoundEvent)SoundRegistry.CATALYST_LOBBER_LOCKED.get(), 1.2f, 0.8f);
                return;
            }
            tag.m_128405_(TIMER, timer);
        }
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        SoundEvent sound;
        ItemStack itemstack = playerIn.m_21120_(handIn);
        CompoundTag tag = itemstack.m_41784_();
        int state = tag.m_128451_(STATE);
        int cooldown = 0;
        switch (state) {
            case 0: {
                cooldown = 100;
                state = Math.max(1, tag.m_128451_(STASHED_STATE));
                sound = (SoundEvent)SoundRegistry.CATALYST_LOBBER_UNLOCKED.get();
                break;
            }
            case 1: {
                ItemStack ammo = ItemStack.f_41583_;
                for (int i = 0; i < playerIn.m_150109_().m_6643_(); ++i) {
                    ItemStack maybeAmmo = playerIn.m_150109_().m_8020_(i);
                    if (!maybeAmmo.m_41720_().equals(ItemRegistry.AURIC_EMBERS.get())) continue;
                    ammo = maybeAmmo;
                    break;
                }
                if (ammo.m_41619_()) {
                    return InteractionResultHolder.m_19100_((Object)itemstack);
                }
                cooldown = 20;
                state = 2;
                ammo.m_41774_(1);
                sound = (SoundEvent)SoundRegistry.CATALYST_LOBBER_PRIMED.get();
                break;
            }
            case 2: {
                if (!worldIn.f_46443_) {
                    AbstractNitrateEntity bombEntity = this.entitySupplier.apply(playerIn);
                    int angle = handIn == InteractionHand.MAIN_HAND ? 225 : 90;
                    Vec3 pos = playerIn.m_20182_().m_82549_(playerIn.m_20154_().m_82490_(0.5)).m_82520_(0.5 * Math.sin(Math.toRadians((float)angle - playerIn.f_20885_)), (double)(playerIn.m_20206_() * 2.0f / 3.0f), 0.5 * Math.cos(Math.toRadians((float)angle - playerIn.f_20885_)));
                    float pitch = -10.0f;
                    bombEntity.m_37251_((Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), pitch, 1.25f, 0.9f);
                    bombEntity.m_146884_(pos);
                    worldIn.m_7967_((Entity)bombEntity);
                }
                playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (!playerIn.m_150110_().f_35937_) {
                    itemstack.m_41622_(1, (LivingEntity)playerIn, p -> p.m_21190_(handIn));
                }
                state = 1;
                sound = (SoundEvent)SoundRegistry.CATALYST_LOBBER_FIRED.get();
                break;
            }
            default: {
                tag.m_128473_(STATE);
                throw new IllegalStateException("Nitrate lobber used with an invalid state.");
            }
        }
        tag.m_128405_(STATE, state);
        if (cooldown != 0) {
            playerIn.m_36335_().m_41524_((Item)this, cooldown);
        }
        playerIn.m_5496_(sound, 1.0f, 1.0f);
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)worldIn.m_5776_());
    }
}

