/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.armor;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.sammy.malum.client.cosmetic.ArmorSkinRenderingData;
import com.sammy.malum.client.model.SoulHunterArmorModel;
import com.sammy.malum.common.item.cosmetic.skins.ArmorSkin;
import com.sammy.malum.common.item.curiosities.armor.MalumArmorItem;
import com.sammy.malum.compability.irons_spellbooks.IronsSpellsCompat;
import com.sammy.malum.registry.client.ModelRegistry;
import com.sammy.malum.registry.common.item.ArmorTiers;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;
import team.lodestar.lodestone.systems.model.LodestoneArmorModel;

public class SoulHunterArmorItem
extends MalumArmorItem {
    public SoulHunterArmorItem(ArmorItem.Type slot, Item.Properties builder) {
        super(ArmorTiers.ArmorTierEnum.SPIRIT_HUNTER, slot, builder);
    }

    public Multimap<Attribute, AttributeModifier> createExtraAttributes(ArmorItem.Type type) {
        ArrayListMultimap attributes = ArrayListMultimap.create();
        UUID uuid = (UUID)ARMOR_MODIFIER_UUID_PER_TYPE.get(type);
        attributes.put((Object)((Attribute)LodestoneAttributeRegistry.MAGIC_PROFICIENCY.get()), (Object)new AttributeModifier(uuid, "Magic Proficiency", (double)0.15f, AttributeModifier.Operation.MULTIPLY_BASE));
        IronsSpellsCompat.addSoulHunterSpellPower((Multimap<Attribute, AttributeModifier>)attributes, uuid);
        return attributes;
    }

    public String getTexture() {
        return "spirit_hunter_reforged";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public LodestoneArmorModel getHumanoidArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel _default) {
                float pticks = Minecraft.m_91087_().m_91296_();
                float f = Mth.m_14189_((float)pticks, (float)entity.f_20884_, (float)entity.f_20883_);
                float f1 = Mth.m_14189_((float)pticks, (float)entity.f_20886_, (float)entity.f_20885_);
                float netHeadYaw = f1 - f;
                float netHeadPitch = Mth.m_14179_((float)pticks, (float)entity.f_19860_, (float)entity.m_146909_());
                ArmorSkin skin = ArmorSkin.getAppliedItemSkin(itemStack);
                SoulHunterArmorModel model = ModelRegistry.SOUL_HUNTER_ARMOR;
                if (skin != null) {
                    model = ArmorSkinRenderingData.RENDERING_DATA.apply(skin).getModel(entity);
                }
                model.slot = armorSlot;
                model.copyFromDefault(_default);
                model.m_6973_(entity, entity.f_267362_.m_267756_(), entity.f_267362_.m_267731_(), (float)entity.f_19797_ + pticks, netHeadYaw, netHeadPitch);
                return model;
            }
        });
    }
}

