/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.runes.miracle;

import com.google.common.collect.Multimap;
import com.sammy.malum.common.item.curiosities.curios.runes.AbstractRuneCurioItem;
import com.sammy.malum.registry.common.SpiritTypeRegistry;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public class RuneDexterityItem
extends AbstractRuneCurioItem {
    public RuneDexterityItem(Item.Properties builder) {
        super(builder, SpiritTypeRegistry.AERIAL_SPIRIT);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(RuneDexterityItem.positiveEffect("low_health_speed", new Object[0]));
    }

    @Override
    public void addAttributeModifiers(Multimap<Attribute, AttributeModifier> map, final SlotContext slotContext, ItemStack stack) {
        this.addAttributeModifier(map, Attributes.f_22279_, uuid -> new AttributeModifier((UUID)uuid, "Curio Movement Speed", 0.2f, AttributeModifier.Operation.MULTIPLY_TOTAL){

            public double m_22218_() {
                double amount = super.m_22218_();
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity != null) {
                    float health = livingEntity.m_21223_();
                    float maxHealth = livingEntity.m_21233_();
                    float pct = health / maxHealth;
                    return amount * (double)(2.0f - pct);
                }
                return amount;
            }
        });
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        AttributeInstance attribute;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity.m_9236_().m_46467_() % 5L == 0L && (attribute = livingEntity.m_21051_(Attributes.f_22279_)) != null) {
            attribute.m_22129_();
        }
    }
}

